"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.resolveOpaqueOnAddressSpace = resolveOpaqueOnAddressSpace;
const node_opcua_client_dynamic_extension_object_1 = require("node-opcua-client-dynamic-extension-object");
const node_opcua_variant_1 = require("node-opcua-variant");
const pseudo_session_1 = require("../pseudo_session");
const ensure_datatype_extracted_1 = require("../loader/ensure_datatype_extracted");
async function resolveOpaqueOnAddressSpace(addressSpace, variants) {
    if (!variants) {
        return;
    }
    const session = new pseudo_session_1.PseudoSession(addressSpace);
    const extraDataTypeManager = await (0, ensure_datatype_extracted_1.ensureDatatypeExtracted)(addressSpace);
    if (variants instanceof node_opcua_variant_1.Variant) {
        await (0, node_opcua_client_dynamic_extension_object_1.resolveDynamicExtensionObject)(session, variants, extraDataTypeManager);
        return;
    }
    // resolve opaque data structure from inputArguments
    for (const variant of variants) {
        if (variant) {
            await (0, node_opcua_client_dynamic_extension_object_1.resolveDynamicExtensionObject)(session, variant, extraDataTypeManager);
        }
    }
}
//# sourceMappingURL=resolve_opaque_on_address_space.js.map