"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.convertToCallbackFunction = convertToCallbackFunction;
exports.convertToCallbackFunction1 = convertToCallbackFunction1;
const node_opcua_debug_1 = require("node-opcua-debug");
const warningLog = (0, node_opcua_debug_1.make_warningLog)(__filename);
function convertToCallbackFunction(func) {
    if (func.length === 0) {
        return function (callback) {
            /** */
            let valueOrPromise;
            try {
                valueOrPromise = func.call(this);
            }
            catch (err) {
                return callback(err);
            }
            if (valueOrPromise instanceof Promise) {
                valueOrPromise.then((value) => callback(null, value)).catch((err) => callback(err));
            }
            else {
                return callback(null, valueOrPromise);
            }
        };
    }
    else {
        if (func.length !== 1) {
            throw new Error("convertToCallbackFunction: invalid function");
        }
        return function (callback) {
            try {
                func.call(this, callback);
            }
            catch (err) {
                warningLog("internal error", err.message);
                callback(err);
            }
        };
    }
}
function convertToCallbackFunction1(func) {
    if (func.length === 1) {
        return function (param, callback) {
            /** */
            let valueOrPromise;
            try {
                valueOrPromise = func.call(this, param);
            }
            catch (err) {
                return callback(err);
            }
            if (valueOrPromise instanceof Promise) {
                valueOrPromise.then((value) => callback(null, value)).catch((err) => callback(err));
            }
            else {
                return callback(null, valueOrPromise);
            }
        };
    }
    else {
        if (func.length !== 2) {
            throw new Error("convertToCallbackFunction: invalid function");
        }
        return function (param, callback) {
            try {
                func.call(this, param, callback);
            }
            catch (err) {
                warningLog("internal error", err.message);
                callback(err);
            }
        };
    }
}
//# sourceMappingURL=multiform_func.js.map