import * as mqtt from "mqtt";
import * as fs from "fs";
export default class myMqtt {
    #client;
    connected;
    hbInterval = 1000;
    hbTopic = "myscada/stack/heartBeat/";
    hbCounter = 0;
    lastHB = {}; //klic je jmeno modulu
    tagBuffer = {};
    tagTopic = "";
    tagMaxInterval = 50;
    tagMaxCount = 50;
    tagPubTimeout = null;
    //v konstruktoru se preda nazev modulu
    constructor(url, onMessage, subscribeHB, certPath, cert, key, ca, user, pwd, clientId, bufferOut, hbInterval, hbTopic, tagTopic, tagMaxInterval, tagMaxCount) {
        let options = {
            rejectUnauthorized: false, //neoveruje identitu serveru
        };
        if (certPath) {
            if (certPath.slice(-1) != "/")
                certPath += "/";
            options.key = fs.readFileSync(certPath + "client.key");
            options.cert = fs.readFileSync(certPath + "client.crt");
            options.ca = fs.readFileSync(certPath + "../ca/ca.crt");
        }
        else if (cert && key) {
            options.key = key;
            options.cert = cert;
            if (ca) {
                options.ca = ca;
                options.rejectUnauthorized = true;
            }
        }
        if (user)
            options.username = user;
        if (pwd)
            options.password = pwd;
        if (clientId)
            options.clientId = clientId;
        //init hearbeatu
        if (hbInterval)
            this.hbInterval = hbInterval;
        if (hbTopic)
            this.hbTopic = hbTopic;
        //init tag bufferu
        if (tagTopic)
            this.tagTopic = tagTopic;
        if (tagMaxInterval)
            this.tagMaxInterval = tagMaxInterval;
        if (tagMaxCount)
            this.tagMaxCount = tagMaxCount;
        //connect clienta
        this.#client = mqtt.connect(url, options);
        this.connected = this.#client.connected;
        //funkce pro navrat on message
        if (bufferOut) {
            this.#client.on("message", (topic, message, packet) => {
                if (topic.includes(this.hbTopic))
                    this.onHeartBeat(topic, message.toString());
                else
                    onMessage(topic, message, packet);
            });
        }
        else {
            this.#client.on("message", (topic, message, packet) => {
                if (topic.includes(this.hbTopic))
                    this.onHeartBeat(topic, message.toString());
                else
                    onMessage(topic, message.toString(), packet);
            });
        }
        //subscribe heart beat topicu
        if (subscribeHB) {
            this.#client.subscribe(this.hbTopic + "#", function (err) {
                if (err)
                    console.log("ERROR (MQTT): " + err.toString());
            });
        }
        this.#client.on("error", function (error) {
            console.log("ERROR (MQTT): " + error.toString());
        });
    }
    publish(topic, message, error) {
        /*
        this.#client.publish(topic, message, function (err) {
          if (error) error(err);
          if (err) console.log("ERROR (MQTT): " + err.toString());
        });
        */
        this.#client.publish(topic, message);
    }
    async publishAsync(topic, message) {
        return this.#client.publishAsync(topic, message);
        /*return new Promise((resolve, reject) => {
          this.publish(topic, message, function (err) {
            if (!err) resolve(false);
            else reject(err);
          });
        });*/
    }
    //prirazeni tagu do fronty k odeslani
    publishTags(tags) {
        Object.assign(this.tagBuffer, tags);
        //pokud je k odeslani uz vice nez max tagu rovnou odeslu
        if (Object.keys(this.tagBuffer).length >= this.tagMaxCount) {
            this.sendTags();
        }
        //pokud jeste neni nastaveny timeout pro odeslani nastavim
        else if (this.tagPubTimeout == null) {
            this.tagPubTimeout = setTimeout(() => this.sendTags(), this.tagMaxInterval);
        }
    }
    subscribe(topic, error) {
        this.#client.subscribe(topic, function (err) {
            if (error)
                error(err);
            if (err)
                console.log("ERROR (MQTT): " + err.toString());
        });
    }
    async subscribeAsync(topic) {
        return this.#client.subscribeAsync(topic);
        /*return new Promise((resolve, reject) => {
          this.subscribe(topic, function (err) {
            if (!err) resolve(false);
            else reject(err);
          });
        });*/
    }
    unsubscribe(topic) {
        this.#client.unsubscribe(topic);
    }
    end() {
        this.#client.end();
    }
    //Zacne odesilat heart beat s definovanym jmenem modulu
    startHeartBeat(modulName) {
        setInterval(() => {
            this.hbCounter++;
            let message = { tf: new Date().toISOString(), cnt: this.hbCounter };
            try {
                this.#client.publish(this.hbTopic + modulName, JSON.stringify(message), function (err) {
                    if (err)
                        console.log("ERROR sending heart beat (MQTT): " + err.toString());
                });
            }
            catch (e) {
                console.log(e);
            }
        }, this.hbInterval);
    }
    //Kontroluje heartbeat potrebnych modulu, pokud dojde k preruseni vyvola
    //interruptFcn a preda jmena modulu, ktere nebezi
    //limit na cas je 3x delka hb intervalu
    checkHeartBeat(modules, interruptFcn) {
        let lastCnts = {};
        setInterval(() => {
            let faulted = [];
            //projdu vsechny moduly
            for (let module of modules) {
                //init hodnoty pro modul
                if (!this.lastHB.hasOwnProperty(module))
                    this.lastHB[module] = { tf: new Date(0), cnt: 0 };
                if (!lastCnts.hasOwnProperty(module))
                    lastCnts[module] = 0;
                //kontrola jestli se nezresetoval counter
                if (this.lastHB[module].cnt < lastCnts[module]) {
                    faulted.push(module);
                    lastCnts[module] = this.lastHB[module].cnt;
                    continue;
                }
                //update posledniho counteru
                else {
                    lastCnts[module] = this.lastHB[module].cnt;
                }
                //kontrola stari
                let now = new Date();
                if (now.valueOf() - this.lastHB[module].tf.valueOf() - this.hbInterval * 3 > 0) {
                    //kontrola zda byl tento modul s timtou counterem jiz publikovan
                    if (lastCnts[module] != 0) {
                        faulted.push(module);
                        //reset posledni hodnoty, aby se nevolal znovu po nastarnatvovani restart
                        lastCnts[module] = 0;
                        this.lastHB[module].cnt = 0;
                        continue;
                    }
                }
            }
            if (faulted.length > 0) {
                interruptFcn(faulted);
            }
        }, this.hbInterval);
    }
    //funkce, ktera ceka na prichod heart beatu vsech pozadovanych modulu
    async waitForHeartBeat(modules, timeoutMs) {
        let ttt;
        let interval = setInterval(() => {
            let allOK = true;
            //zkontroluju jestli uz mam vsechny heart beaty
            for (let module of modules) {
                if (!this.lastHB.hasOwnProperty(module) || this.lastHB[module].cnt == 0) {
                    allOK = false;
                    break;
                }
            }
            if (allOK) {
                ttt();
                clearInterval(interval);
                return;
            }
        }, 500);
        await new Promise((resolve, reject) => {
            ttt = resolve;
            if (timeoutMs) {
                let msgTmr = setTimeout(() => {
                    clearInterval(interval);
                    reject("Timeout");
                }, timeoutMs);
            }
        });
        clearInterval(interval);
    }
    //funkce ktera pri prichodu heartbeatu updatne stav
    onHeartBeat(topic, message) {
        let parts = topic.split("/");
        let module = parts[parts.length - 1];
        //pokud je modul jen cislo - je to id connectionu
        if (parseInt(module)) {
            //heartbeat pro tenantID
            if (parts.length > 2 && parseInt(parts[parts.length - 3])) {
                module = parts[parts.length - 3] + "/" + parts[parts.length - 2] + "/" + parts[parts.length - 1];
            }
            else
                module = parts[parts.length - 2] + "/" + parts[parts.length - 1];
        }
        let msgObj = JSON.parse(message);
        this.lastHB[module] = { cnt: msgObj.cnt, tf: new Date(msgObj.tf) };
    }
    sendTags() {
        if (this.tagPubTimeout != null) {
            clearTimeout(this.tagPubTimeout);
            this.tagPubTimeout = null;
        }
        if (this.tagBuffer) {
            let pubMsg = {
                payload: {
                    msgType: "dataPubProto",
                    data: this.tagBuffer,
                },
            };
            this.publish(this.tagTopic, JSON.stringify(pubMsg, (key, value) => (typeof value === "bigint" ? Number(value) : value)));
            this.tagBuffer = {};
        }
    }
}
//# sourceMappingURL=data:application/json;base64,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