"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _myMqtt_client;
Object.defineProperty(exports, "__esModule", { value: true });
const mqtt = __importStar(require("mqtt"));
const fs = __importStar(require("fs"));
class myMqtt {
    //v konstruktoru se preda nazev modulu
    constructor(url, onMessage, subscribeHB, certPath, cert, key, ca, user, pwd, clientId, bufferOut, hbInterval, hbTopic, tagTopic, tagMaxInterval, tagMaxCount) {
        _myMqtt_client.set(this, void 0);
        this.hbInterval = 1000;
        this.hbTopic = "myscada/stack/heartBeat/";
        this.hbCounter = 0;
        this.lastHB = {}; //klic je jmeno modulu
        this.tagBuffer = {};
        this.tagTopic = "";
        this.tagMaxInterval = 50;
        this.tagMaxCount = 50;
        this.tagPubTimeout = null;
        let options = {
            rejectUnauthorized: false, //neoveruje identitu serveru
        };
        if (certPath) {
            if (certPath.slice(-1) != "/")
                certPath += "/";
            options.key = fs.readFileSync(certPath + "client.key");
            options.cert = fs.readFileSync(certPath + "client.crt");
            options.ca = fs.readFileSync(certPath + "../ca/ca.crt");
        }
        else if (cert && key) {
            options.key = key;
            options.cert = cert;
            if (ca) {
                options.ca = ca;
                options.rejectUnauthorized = true;
            }
        }
        if (user)
            options.username = user;
        if (pwd)
            options.password = pwd;
        if (clientId)
            options.clientId = clientId;
        //init hearbeatu
        if (hbInterval)
            this.hbInterval = hbInterval;
        if (hbTopic)
            this.hbTopic = hbTopic;
        //init tag bufferu
        if (tagTopic)
            this.tagTopic = tagTopic;
        if (tagMaxInterval)
            this.tagMaxInterval = tagMaxInterval;
        if (tagMaxCount)
            this.tagMaxCount = tagMaxCount;
        //connect clienta
        __classPrivateFieldSet(this, _myMqtt_client, mqtt.connect(url, options), "f");
        this.connected = __classPrivateFieldGet(this, _myMqtt_client, "f").connected;
        //funkce pro navrat on message
        if (bufferOut) {
            __classPrivateFieldGet(this, _myMqtt_client, "f").on("message", (topic, message, packet) => {
                if (topic.includes(this.hbTopic))
                    this.onHeartBeat(topic, message.toString());
                else
                    onMessage(topic, message, packet);
            });
        }
        else {
            __classPrivateFieldGet(this, _myMqtt_client, "f").on("message", (topic, message, packet) => {
                if (topic.includes(this.hbTopic))
                    this.onHeartBeat(topic, message.toString());
                else
                    onMessage(topic, message.toString(), packet);
            });
        }
        //subscribe heart beat topicu
        if (subscribeHB) {
            __classPrivateFieldGet(this, _myMqtt_client, "f").subscribe(this.hbTopic + "#", function (err) {
                if (err)
                    console.log("ERROR (MQTT): " + err.toString());
            });
        }
        __classPrivateFieldGet(this, _myMqtt_client, "f").on("error", function (error) {
            console.log("ERROR (MQTT): " + error.toString());
        });
    }
    publish(topic, message, error) {
        /*
        this.#client.publish(topic, message, function (err) {
          if (error) error(err);
          if (err) console.log("ERROR (MQTT): " + err.toString());
        });
        */
        __classPrivateFieldGet(this, _myMqtt_client, "f").publish(topic, message);
    }
    publishAsync(topic, message) {
        return __awaiter(this, void 0, void 0, function* () {
            return __classPrivateFieldGet(this, _myMqtt_client, "f").publishAsync(topic, message);
            /*return new Promise((resolve, reject) => {
              this.publish(topic, message, function (err) {
                if (!err) resolve(false);
                else reject(err);
              });
            });*/
        });
    }
    //prirazeni tagu do fronty k odeslani
    publishTags(tags) {
        Object.assign(this.tagBuffer, tags);
        //pokud je k odeslani uz vice nez max tagu rovnou odeslu
        if (Object.keys(this.tagBuffer).length >= this.tagMaxCount) {
            this.sendTags();
        }
        //pokud jeste neni nastaveny timeout pro odeslani nastavim
        else if (this.tagPubTimeout == null) {
            this.tagPubTimeout = setTimeout(() => this.sendTags(), this.tagMaxInterval);
        }
    }
    subscribe(topic, error) {
        __classPrivateFieldGet(this, _myMqtt_client, "f").subscribe(topic, function (err) {
            if (error)
                error(err);
            if (err)
                console.log("ERROR (MQTT): " + err.toString());
        });
    }
    subscribeAsync(topic) {
        return __awaiter(this, void 0, void 0, function* () {
            return __classPrivateFieldGet(this, _myMqtt_client, "f").subscribeAsync(topic);
            /*return new Promise((resolve, reject) => {
              this.subscribe(topic, function (err) {
                if (!err) resolve(false);
                else reject(err);
              });
            });*/
        });
    }
    unsubscribe(topic) {
        __classPrivateFieldGet(this, _myMqtt_client, "f").unsubscribe(topic);
    }
    end() {
        __classPrivateFieldGet(this, _myMqtt_client, "f").end();
    }
    //Zacne odesilat heart beat s definovanym jmenem modulu
    startHeartBeat(modulName) {
        setInterval(() => {
            this.hbCounter++;
            let message = { tf: new Date().toISOString(), cnt: this.hbCounter };
            try {
                __classPrivateFieldGet(this, _myMqtt_client, "f").publish(this.hbTopic + modulName, JSON.stringify(message), function (err) {
                    if (err)
                        console.log("ERROR sending heart beat (MQTT): " + err.toString());
                });
            }
            catch (e) {
                console.log(e);
            }
        }, this.hbInterval);
    }
    //Kontroluje heartbeat potrebnych modulu, pokud dojde k preruseni vyvola
    //interruptFcn a preda jmena modulu, ktere nebezi
    //limit na cas je 3x delka hb intervalu
    checkHeartBeat(modules, interruptFcn) {
        let lastCnts = {};
        setInterval(() => {
            let faulted = [];
            //projdu vsechny moduly
            for (let module of modules) {
                //init hodnoty pro modul
                if (!this.lastHB.hasOwnProperty(module))
                    this.lastHB[module] = { tf: new Date(0), cnt: 0 };
                if (!lastCnts.hasOwnProperty(module))
                    lastCnts[module] = 0;
                //kontrola jestli se nezresetoval counter
                if (this.lastHB[module].cnt < lastCnts[module]) {
                    faulted.push(module);
                    lastCnts[module] = this.lastHB[module].cnt;
                    continue;
                }
                //update posledniho counteru
                else {
                    lastCnts[module] = this.lastHB[module].cnt;
                }
                //kontrola stari
                let now = new Date();
                if (now.valueOf() - this.lastHB[module].tf.valueOf() - this.hbInterval * 3 > 0) {
                    //kontrola zda byl tento modul s timtou counterem jiz publikovan
                    if (lastCnts[module] != 0) {
                        faulted.push(module);
                        //reset posledni hodnoty, aby se nevolal znovu po nastarnatvovani restart
                        lastCnts[module] = 0;
                        this.lastHB[module].cnt = 0;
                        continue;
                    }
                }
            }
            if (faulted.length > 0) {
                interruptFcn(faulted);
            }
        }, this.hbInterval);
    }
    //funkce, ktera ceka na prichod heart beatu vsech pozadovanych modulu
    waitForHeartBeat(modules, timeoutMs) {
        return __awaiter(this, void 0, void 0, function* () {
            let ttt;
            let interval = setInterval(() => {
                let allOK = true;
                //zkontroluju jestli uz mam vsechny heart beaty
                for (let module of modules) {
                    if (!this.lastHB.hasOwnProperty(module) || this.lastHB[module].cnt == 0) {
                        allOK = false;
                        break;
                    }
                }
                if (allOK) {
                    ttt();
                    clearInterval(interval);
                    return;
                }
            }, 500);
            yield new Promise((resolve, reject) => {
                ttt = resolve;
                if (timeoutMs) {
                    let msgTmr = setTimeout(() => {
                        clearInterval(interval);
                        reject("Timeout");
                    }, timeoutMs);
                }
            });
            clearInterval(interval);
        });
    }
    //funkce ktera pri prichodu heartbeatu updatne stav
    onHeartBeat(topic, message) {
        let parts = topic.split("/");
        let module = parts[parts.length - 1];
        //pokud je modul jen cislo - je to id connectionu
        if (parseInt(module)) {
            //heartbeat pro tenantID
            if (parts.length > 2 && parseInt(parts[parts.length - 3])) {
                module = parts[parts.length - 3] + "/" + parts[parts.length - 2] + "/" + parts[parts.length - 1];
            }
            else
                module = parts[parts.length - 2] + "/" + parts[parts.length - 1];
        }
        let msgObj = JSON.parse(message);
        this.lastHB[module] = { cnt: msgObj.cnt, tf: new Date(msgObj.tf) };
    }
    sendTags() {
        if (this.tagPubTimeout != null) {
            clearTimeout(this.tagPubTimeout);
            this.tagPubTimeout = null;
        }
        if (this.tagBuffer) {
            let pubMsg = {
                payload: {
                    msgType: "dataPubProto",
                    data: this.tagBuffer,
                },
            };
            this.publish(this.tagTopic, JSON.stringify(pubMsg, (key, value) => (typeof value === "bigint" ? Number(value) : value)));
            this.tagBuffer = {};
        }
    }
}
_myMqtt_client = new WeakMap();
exports.default = myMqtt;
//# sourceMappingURL=data:application/json;base64,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