"use strict";
exports.__esModule = true;
var glob = require('glob');
var path = require('path');
var memo = {};
function compare(a, b) {
    var result;
    var ar;
    var br;
    ar = {
        dirname: path.dirname(a).replace(/^\./g, ''),
        basename: path.basename(a).replace(/\:/g, '~')
    };
    br = {
        dirname: path.dirname(b).replace(/^\./g, ''),
        basename: path.basename(b).replace(/\:/g, '~')
    };
    if (ar.dirname === br.dirname) {
        result = -1;
        if (ar.basename > br.basename) {
            result = 1;
        }
    }
    else {
        result = 1;
        if (ar.dirname < br.dirname) {
            result = -1;
        }
    }
    return result;
}
function fsRoutes(dir, options) {
    if (options === void 0) { options = {}; }
    dir = path.resolve(process.cwd(), dir);
    options.glob = options.glob || '**/*.js';
    options.indexFileRegExp = options.indexFileRegExp || /(?:index)?\.js$/;
    var cacheKey = dir + options.glob;
    if (!memo[cacheKey]) {
        memo[cacheKey] = glob
            .sync(options.glob, { cwd: dir })
            .sort(compare)
            .map(function (file) { return ({
            path: path.resolve(dir, file),
            route: '/' + file.replace(options.indexFileRegExp, '')
        }); });
    }
    return memo[cacheKey];
}
exports["default"] = fsRoutes;
//# sourceMappingURL=index.js.map