import { nanoid } from "nanoid/non-secure";
export var ToastActionTypes;
(function (ToastActionTypes) {
    ToastActionTypes["ADD_TOAST"] = "ADD_TOAST";
    ToastActionTypes["REMOVE_TOAST"] = "REMOVE_TOAST";
    ToastActionTypes["SET_HEIGHT"] = "SET_HEIGHT";
    ToastActionTypes["SET_EXITING"] = "SET_EXITING";
})(ToastActionTypes || (ToastActionTypes = {}));
export default (toasts = [], action) => {
    switch (action.type) {
        case ToastActionTypes.ADD_TOAST:
            return [
                {
                    id: nanoid(5),
                    title: action.title,
                    message: action.message,
                    type: action.toastType || 'info',
                    duration: action.duration || 10000,
                    height: 0,
                    exiting: false
                },
                ...toasts
            ];
        case ToastActionTypes.SET_HEIGHT: {
            const index = toasts.findIndex(t => t.id === action.id);
            return [
                ...toasts.slice(0, index),
                {
                    ...toasts[index],
                    height: action.height
                },
                ...toasts.slice(index + 1)
            ];
        }
        case ToastActionTypes.SET_EXITING: {
            const index = toasts.findIndex(t => t.id === action.id);
            return [
                ...toasts.slice(0, index),
                {
                    ...toasts[index],
                    exiting: true
                },
                ...toasts.slice(index + 1)
            ];
        }
        case ToastActionTypes.REMOVE_TOAST: {
            const index = toasts.findIndex(t => t.id === action.id);
            return [
                ...toasts.slice(0, index),
                ...toasts.slice(index + 1)
            ];
        }
        default:
            return toasts;
    }
};
//# sourceMappingURL=toastsReducer.js.map