export var StageActionType;
(function (StageActionType) {
    StageActionType["SET_SCALE"] = "SET_SCALE";
    StageActionType["SET_TRANSLATE"] = "SET_TRANSLATE";
    StageActionType["SET_TRANSLATE_SCALE"] = "SET_TRANSLATE_SCALE";
})(StageActionType || (StageActionType = {}));
export default (state, incomingAction) => {
    let action = typeof incomingAction === "function"
        ? incomingAction(state)
        : incomingAction;
    switch (action.type) {
        case StageActionType.SET_SCALE:
            return { ...state, scale: action.scale };
        case StageActionType.SET_TRANSLATE:
            return { ...state, translate: action.translate };
        case StageActionType.SET_TRANSLATE_SCALE:
            return { ...state, translate: action.translate, scale: action.scale };
        default:
            return state;
    }
};
//# sourceMappingURL=stageReducer.js.map