import React from "react";
import { ToastActionTypes } from "../../toastsReducer";
import styles from "./Toaster.css";
const Toaster = ({ toasts = [], dispatchToasts }) => {
    const setHeight = React.useCallback((id, height) => {
        dispatchToasts({
            type: ToastActionTypes.SET_HEIGHT,
            id,
            height
        });
    }, [dispatchToasts]);
    const startExit = React.useCallback((id) => {
        dispatchToasts({
            type: ToastActionTypes.SET_EXITING,
            id
        });
    }, [dispatchToasts]);
    const removeToast = React.useCallback((id) => {
        dispatchToasts({
            type: ToastActionTypes.REMOVE_TOAST,
            id
        });
    }, [dispatchToasts]);
    return (React.createElement("div", { className: styles.toaster }, toasts.map((toast, i) => {
        return (React.createElement(Toast, { ...toast, onHeightReceived: setHeight, onExitRequested: startExit, onRemoveRequested: removeToast, y: toasts.slice(0, i + 1).reduce((y, t) => t.height + y + 5, 0), key: toast.id }));
    })));
};
const Toast = ({ id, title, message, duration, type, exiting, y, onHeightReceived, onExitRequested, onRemoveRequested }) => {
    const [paused, setPaused] = React.useState(false);
    const wrapper = React.useRef(null);
    const timer = React.useRef();
    const stopTimer = React.useCallback(() => {
        setPaused(true);
        if (timer.current) {
            clearTimeout(timer.current);
        }
    }, []);
    const resumeTimer = React.useCallback(() => {
        setPaused(false);
        timer.current = setTimeout(() => onExitRequested(id), duration);
    }, [id, duration, onExitRequested]);
    React.useLayoutEffect(() => {
        if (wrapper.current) {
            const { height } = wrapper.current.getBoundingClientRect();
            onHeightReceived(id, height);
        }
    }, [onHeightReceived, id]);
    React.useEffect(() => {
        resumeTimer();
        return stopTimer;
    }, [resumeTimer, stopTimer]);
    const handleAnimationEnd = () => {
        if (exiting) {
            onRemoveRequested(id);
        }
    };
    return (React.createElement("div", { "data-flume-component": "toast", ref: wrapper, className: styles.toast, "data-type": type, style: { transform: `translateY(-${y}px)` }, "data-exiting": exiting, onAnimationEnd: handleAnimationEnd, onMouseEnter: stopTimer, onMouseLeave: resumeTimer, role: "alert" },
        title ? (React.createElement("span", { "data-flume-component": "toast-title", className: styles.title }, title)) : null,
        React.createElement("p", { "data-flume-component": "toast-message" }, message),
        !paused && (React.createElement("div", { className: styles.timer, style: { animationDuration: `${duration}ms` }, onAnimationEnd: e => e.stopPropagation() })),
        React.createElement("button", { "data-flume-component": "toast-close", className: styles.exitButton, onClick: () => {
                stopTimer();
                onExitRequested(id);
            } }, "\u2715")));
};
export default Toaster;
//# sourceMappingURL=Toaster.js.map