import React from "react";
import styles from "./Control.css";
import Checkbox from "../Checkbox/Checkbox";
import TextInput from "../TextInput/TextInput";
import Select from "../Select/Select";
import { NodeDispatchContext, ContextContext } from "../../context";
import { NodesActionType } from "../../nodesReducer";
const Control = (props) => {
    const { type, name, nodeId, portName, label, inputLabel, data, allData, inputData, triggerRecalculation, updateNodeConnections, setValue, defaultValue, isMonoControl } = props;
    const nodesDispatch = React.useContext(NodeDispatchContext);
    const executionContext = React.useContext(ContextContext);
    const calculatedLabel = isMonoControl ? inputLabel : label;
    const onChange = (data) => {
        if (nodesDispatch) {
            nodesDispatch({
                type: NodesActionType.SET_PORT_DATA,
                data,
                nodeId,
                portName,
                controlName: name,
                setValue
            });
        }
        triggerRecalculation();
    };
    const getControlByType = (type) => {
        const commonProps = {
            triggerRecalculation,
            updateNodeConnections,
            onChange,
            data
        };
        switch (type) {
            case "select": {
                const { options, getOptions, placeholder } = props;
                return (React.createElement(Select, { ...commonProps, options: getOptions ? getOptions(inputData, executionContext) : options, placeholder: placeholder }));
            }
            case "text": {
                const { placeholder } = props;
                return React.createElement(TextInput, { ...commonProps, placeholder: placeholder });
            }
            case "number": {
                const { step, placeholder } = props;
                return (React.createElement(TextInput, { ...commonProps, step: step, type: "number", placeholder: placeholder }));
            }
            case "checkbox":
                return React.createElement(Checkbox, { ...commonProps, label: calculatedLabel });
            case "multiselect": {
                const { options, getOptions, placeholder } = props;
                return (React.createElement(Select, { allowMultiple: true, ...commonProps, options: getOptions ? getOptions(inputData, executionContext) : options, placeholder: placeholder }));
            }
            case "custom": {
                const { render } = props;
                return (render?.(data, onChange, executionContext, triggerRecalculation, {
                    label,
                    name,
                    portName,
                    inputLabel,
                    defaultValue
                }, allData) ?? null);
            }
            default:
                return React.createElement("div", null, "Control");
        }
    };
    return (React.createElement("div", { className: styles.wrapper, "data-flume-component": "control" },
        calculatedLabel && type !== "checkbox" && type !== "custom" && (React.createElement("label", { "data-flume-component": "control-label", className: styles.controlLabel }, calculatedLabel)),
        getControlByType(type)));
};
export default Control;
//# sourceMappingURL=Control.js.map