import React from "react";
import styles from "./Checkbox.css";
import { nanoid } from "nanoid/non-secure";
const Checkbox = ({ label, data, onChange }) => {
    const id = React.useRef(nanoid(10));
    return (React.createElement("div", { className: styles.wrapper },
        React.createElement("input", { "data-flume-component": "checkbox", className: styles.checkbox, type: "checkbox", id: id.current, checked: data, onChange: e => onChange(e.target.checked) }),
        React.createElement("label", { "data-flume-component": "checkbox-label", className: styles.label, htmlFor: id.current }, label)));
};
export default Checkbox;
//# sourceMappingURL=Checkbox.js.map