import { nanoid } from "nanoid/non-secure";
export var CommentActionTypes;
(function (CommentActionTypes) {
    CommentActionTypes["ADD_COMMENT"] = "ADD_COMMENT";
    CommentActionTypes["REMOVE_COMMENT_NEW"] = "REMOVE_COMMENT_NEW";
    CommentActionTypes["SET_COMMENT_COORDINATES"] = "SET_COMMENT_COORDINATES";
    CommentActionTypes["SET_COMMENT_DIMENSIONS"] = "SET_COMMENT_DIMENSIONS";
    CommentActionTypes["SET_COMMENT_TEXT"] = "SET_COMMENT_TEXT";
    CommentActionTypes["SET_COMMENT_COLOR"] = "SET_COMMENT_COLOR";
    CommentActionTypes["DELETE_COMMENT"] = "DELETE_COMMENT";
})(CommentActionTypes || (CommentActionTypes = {}));
const setComment = (comments, id, merge) => {
    const existingComment = comments[id];
    if (!existingComment)
        return comments;
    return {
        ...comments,
        [id]: {
            ...existingComment,
            ...merge
        }
    };
};
const commentsReducer = (comments = {}, action) => {
    switch (action.type) {
        case CommentActionTypes.ADD_COMMENT: {
            const comment = {
                id: nanoid(10),
                text: "",
                x: action.x,
                y: action.y,
                width: 200,
                height: 30,
                color: "blue",
                isNew: true
            };
            return {
                ...comments,
                [comment.id]: comment
            };
        }
        case CommentActionTypes.REMOVE_COMMENT_NEW:
            const { isNew: toDelete, ...comment } = comments[action.id];
            return {
                ...comments,
                [action.id]: comment
            };
        case CommentActionTypes.SET_COMMENT_COORDINATES: {
            return setComment(comments, action.id, { x: action.x, y: action.y });
        }
        case CommentActionTypes.SET_COMMENT_DIMENSIONS: {
            return setComment(comments, action.id, {
                width: action.width,
                height: action.height
            });
        }
        case CommentActionTypes.SET_COMMENT_TEXT: {
            return setComment(comments, action.id, { text: action.text });
        }
        case CommentActionTypes.SET_COMMENT_COLOR: {
            return setComment(comments, action.id, { color: action.color });
        }
        case CommentActionTypes.DELETE_COMMENT: {
            const { [action.id]: toDelete, ...newComments } = comments;
            return newComments;
        }
        default:
            return comments;
    }
};
export default commentsReducer;
//# sourceMappingURL=commentsReducer.js.map