import { Application, ErrorRequestHandler, RequestHandler } from 'express';
import OpenAPIFramework, { OpenAPIFrameworkArgs } from 'openapi-framework';
import { OpenAPI } from 'openapi-types';
export interface OperationFunction extends RequestHandler {
    apiDoc?: OpenAPI.Operation;
}
export interface OperationHandlerArray {
    apiDoc?: OpenAPI.Operation;
    [index: number]: RequestHandler;
}
export declare type Operation = OperationFunction | OperationHandlerArray;
export interface ExpressOpenAPIArgs extends OpenAPIFrameworkArgs {
    app: Application;
    consumesMiddleware?: {
        [mimeType: string]: RequestHandler;
    };
    docsPath?: string;
    errorMiddleware?: ErrorRequestHandler;
    exposeApiDocs?: boolean;
    promiseMode?: boolean;
    securityFilter?: RequestHandler;
}
export declare function initialize(args: ExpressOpenAPIArgs): Promise<OpenAPIFramework>;
