import http from "http";
//const MarkdownIt = require("markdown-it");
import MarkdownIt from "markdown-it";
//const http = require("http");
export function stripArrayTags(tags) {
    let _tags = [];
    for (let _t of tags) {
        let t = _t;
        if (t.includes("/")) {
            t = t.split("/")[0];
        }
        if (t.includes("[") && !t.includes("].")) {
            t = t.split("[")[0];
        }
        if (!_tags.includes(t)) {
            _tags.push(t);
        }
    }
    return _tags;
}
export function stripArrayTag(tag) {
    let t = tag;
    if (t.includes("/")) {
        t = t.split("/")[0];
    }
    if (t.includes("[") && !t.includes("].")) {
        t = t.split("[")[0];
    }
    return t;
}
export function getTagValue(tagIn, value) {
    let index = -1;
    let bit = -1;
    let tag = tagIn;
    if (tagIn.includes("/")) {
        let parts = tag.split("/");
        bit = parseInt(parts[1]);
        tag = parts[0];
    }
    //zprocesujeme i pole
    if (tag.includes("[") && !tag.includes("].")) {
        //kolikaty je to index v poli
        let match = tag.match(/\[(\d+)\]$/);
        if (match) {
            index = parseInt(match[1]);
        }
        tag = tag.split("[")[0];
    }
    if (index == -1 && bit == -1) {
        return value;
    }
    if (index == -1) {
        index = 0;
    }
    if (value.length < index - 1) {
        return null;
    }
    let v = value[index];
    if (bit >= 0) {
        v = (v >>> bit) & 1;
    }
    return [v];
}
export function tagsToArrayTags(arrayTags, tags) {
    let res = {};
    for (let t of arrayTags) {
        let tag = stripArrayTag(t);
        let o = tags[tag];
        if (o) {
            res[t] = getTagValue(t, o.value);
        }
    }
    return res;
}
export async function _post(tenantid, url, port, postData, customIP) {
    return new Promise((resolve, reject) => {
        let data = "";
        // Options for the POST request
        let ip = "127.0.0.1";
        if (customIP) {
            ip = customIP;
        }
        const options = {
            hostname: ip,
            port: port,
            path: url,
            method: "POST",
            headers: {
                "Content-Type": "application/json",
                "Content-Length": Buffer.byteLength(postData),
                "x-tenantid": tenantid,
                apikey: "internalapi",
            },
        };
        // Make the POST request
        const req = http.request(options, (res) => {
            // Handling response data
            res.on("data", (chunk) => {
                data += chunk;
            });
            res.on("end", () => {
                try {
                    let d = JSON.parse(data);
                    resolve(d);
                }
                catch (e) {
                    reject(e);
                }
            });
        });
        // Handling errors
        req.on("error", (error) => {
            reject(error);
        });
        // Send the data
        req.write(postData);
        req.end();
    });
}
export async function _get(url) {
    return new Promise((resolve, reject) => {
        let data = "";
        const req = http.get(url, (res) => {
            res.on("data", (chunk) => {
                data += chunk;
            });
            res.on("end", () => {
                try {
                    let d = JSON.parse(data);
                    resolve(d);
                }
                catch (e) {
                    reject(e);
                }
            });
        });
        // Handling HTTP request errors
        req.on("error", (err) => {
            reject(new Error("HTTP request failed: " + err.message));
        });
        // Timeout handler
        req.on("timeout", () => {
            req.abort();
            reject(new Error("HTTP request timed out"));
        });
    });
}
export function formatDate(date, format, locale = "en-US") {
    try {
        date = new Date(date);
        const monthLong = new Intl.DateTimeFormat(locale, { month: "long" }).format(date);
        const yyyy = date.getFullYear() + "";
        const MM = String(date.getMonth() + 1).padStart(2, "0");
        const dd = String(date.getDate()).padStart(2, "0");
        const HH = String(date.getHours()).padStart(2, "0");
        const hh = String(date.getHours() % 12 || 12).padStart(2, "0");
        const mm = String(date.getMinutes()).padStart(2, "0");
        const ss = String(date.getSeconds()).padStart(2, "0");
        const a = date.getHours() < 12 ? "AM" : "PM";
        return format
            .replace(/yyyy/g, yyyy)
            .replace(/MMMM/g, monthLong)
            .replace(/MM/g, MM)
            .replace(/dd/g, dd)
            .replace(/HH/g, HH)
            .replace(/hh/g, hh)
            .replace(/mm/g, mm)
            .replace(/ss/g, ss)
            .replace(/\ba\b/g, a); // match only whole word "a" to avoid false positives
    }
    catch (e) {
        return "";
    }
}
export function formatNumber(value, format) {
    if (value == null) {
        return "";
    }
    // Split the format into integer and decimal parts
    const [intFormat, decimalFormat] = format.split(".");
    // Split the value into integer and decimal parts
    let [intValue, decimalValue] = value.toString().split(".");
    intValue = intValue || "0"; // Fallback if integer part is empty
    decimalValue = decimalValue || ""; // Fallback if decimal part is missing
    // Handle the integer part
    let formattedInt = "";
    let intFormatIndex = intFormat.length - 1;
    let intValueIndex = intValue.length - 1;
    // This loop ensures that all digits are kept and not dropped
    while (intFormatIndex >= 0 || intValueIndex >= 0) {
        let currentFormatChar = intFormat[intFormatIndex] || "#"; // Default to '#' when the format string ends
        if (currentFormatChar === "0" || currentFormatChar === "#") {
            // Add the corresponding number or pad with 0 if needed
            formattedInt = (intValueIndex >= 0 ? intValue[intValueIndex] : currentFormatChar === "0" ? "0" : "") + formattedInt;
            intValueIndex--;
        }
        else {
            // Add any other characters in the format (like commas, spaces)
            formattedInt = currentFormatChar + formattedInt;
        }
        intFormatIndex--;
    }
    // Handle the decimal part if specified in the format
    let formattedDecimal = "";
    if (decimalFormat) {
        for (let i = 0; i < decimalFormat.length; i++) {
            if (decimalFormat[i] === "0" || decimalFormat[i] === "#") {
                // Add the corresponding decimal digits or pad with 0 if required
                formattedDecimal += decimalValue[i] || (decimalFormat[i] === "0" ? "0" : "");
            }
            else {
                formattedDecimal += decimalFormat[i];
            }
        }
    }
    // Combine the integer and decimal parts
    let result = formattedInt;
    if (formattedDecimal) {
        result += "." + formattedDecimal;
    }
    // Replace any custom text part in the format (for cases like "Value 00.00 °C")
    return format.replace(/[#0.,]+/, result);
}
export function getLocalizedStringForObject(d, language, defaultStr) {
    if (d == null) {
        return defaultStr;
    }
    if (typeof d === "string") {
        return d;
    }
    let m = d[language];
    if (!m) {
        m = d["en"];
    }
    if (!m) {
        let klic = Object.keys(d);
        if (klic.length > 0) {
            m = d[klic[0]];
        }
        else {
            m = defaultStr;
        }
    }
    return m;
}
export function processMessageWithTagReplace(tag, language, message) {
    let _tag = {
        tagFormat: tag.format,
        tagUnit: tag.unit,
        tagLabel: tag.label,
        tagNote: tag.note,
        message: message,
        id: tag._id,
    };
    correctAlarms([_tag], language);
    return _tag.message;
}
function correctAlarms(items, _language, definition, tf) {
    for (let d of items) {
        let langs = [];
        if (typeof _language === "string") {
            langs = [_language];
        }
        else {
            langs = _language;
        }
        let finalMsg = {};
        for (let i = 0; i < langs.length; i++) {
            let language = langs[i];
            //zapracujeme prevod datumu pokud je definovano tf
            if (tf) {
                let newDat = formatDate(d.tf, tf, language);
                d.tf = newDat;
                if (d.actTime) {
                    d.actTime = formatDate(d.actTime, tf, language);
                }
                if (d.deActTime) {
                    d.deActTime = formatDate(d.deActTime, tf, language);
                }
                if (d.confTime) {
                    d.confTime = formatDate(d.confTime, tf, language);
                }
                let m = getLocalizedStringForObject(d.tagFormat, language, "#0.0");
                if (d.value != null)
                    d.value = formatNumber(d.value, m);
                if (d.difference != null)
                    d.difference = formatNumber(d.difference, m);
                if (d.limit != null)
                    d.limit = formatNumber(d.limit, m);
                if (d.limitto != null)
                    d.limitto = formatNumber(d.limitto, m);
                if (d.action === 0) {
                    d.status = "ACT";
                }
                else if (d.action === 1) {
                    d.status = "DEACT";
                }
                else if (d.action === 2) {
                    d.status = "CONF";
                }
                else if (d.action === 3) {
                    d.status = "SUPP";
                }
                else if (d.action === 4) {
                    d.status = "UNSUPP";
                }
                else if (d.action === 5) {
                    d.status = "ERRORED";
                }
                else {
                    d.status = "?";
                }
            }
            let m = getLocalizedStringForObject(d.message, language, "");
            //neni nastavena zprava pro alarmy vytvorime defaultni
            if (m == null || m == "") {
                m = "{tag.labelOrName}. Value: {tag.value}{tag.unit}. Limit: {limit.value}{tag.unit}.";
            }
            m = m.replace(/\{tagValue:(\d+)(?:\s+DP:([^\s\}]+))?(?:\s+L:([^\s\}]+))?(?:\s+VTT:([^\}]+))?\}/g, (_, index, dpRaw, lenRaw, vtRaw) => {
                const indexInteger = parseInt(index, 10);
                if (d.addTags && Array.isArray(d.addTags) && d.addTags.length > indexInteger) {
                    const value = d.addTags[indexInteger];
                    // Validate DP and L
                    const dp = /^\d+$/.test(dpRaw) ? parseInt(dpRaw, 10) : null;
                    const len = /^\d+$/.test(lenRaw) ? parseInt(lenRaw, 10) : null;
                    // Parse VT map if provided
                    let vtMap = null;
                    if (vtRaw) {
                        vtMap = {};
                        vtRaw.split(",").forEach((pair) => {
                            const [k, v] = pair.split("=");
                            if (k && v)
                                vtMap[k.trim()] = v.trim();
                        });
                    }
                    if (typeof value === "number") {
                        if (vtMap) {
                            // Match value as a string to VT map keys
                            const mapped = vtMap[String(value)];
                            return mapped !== undefined ? mapped : "?";
                        }
                        else if (dp !== null) {
                            return value.toFixed(dp);
                        }
                        else if (!Number.isInteger(value)) {
                            return value.toFixed(2); // default rounding
                        }
                        else {
                            return value.toString(); // integer
                        }
                    }
                    else if (typeof value === "string") {
                        if (len !== null) {
                            return value.substring(0, len);
                        }
                        else {
                            return value;
                        }
                    }
                }
                return "?"; // fallback for invalid index or type
            });
            let msg = m.replace(/\{([^}]+)\}/g, (match, path) => {
                if (path === "tag.value") {
                    if (definition) {
                        return "__VALUE__";
                    }
                    if (d.value == null) {
                        return "?";
                    }
                    else if (d.tagFormat) {
                        let m = getLocalizedStringForObject(d.tagFormat, language, "#0.0");
                        return formatNumber(d.value, m);
                    }
                    else {
                        return d.value;
                    }
                }
                else if (path === "limit.value") {
                    if (d.limit == null) {
                        return "---";
                    }
                    else if (d.tagFormat) {
                        let m = getLocalizedStringForObject(d.tagFormat, language, "#0.0");
                        return formatNumber(d.limit, m);
                    }
                    else {
                        return d.limit;
                    }
                }
                else if (path === "limit.valueto") {
                    if (d.limitto == null) {
                        return "---";
                    }
                    else if (d.tagFormat) {
                        let m = getLocalizedStringForObject(d.tagFormat, language, "#0.0");
                        return formatNumber(d.limitto, m);
                    }
                    else {
                        return d.limitto;
                    }
                }
                else if (path === "limit.difference") {
                    if (definition) {
                        return "__DIFFERENCE__";
                    }
                    if (d.difference == null) {
                        return "---";
                    }
                    else if (d.tagFormat) {
                        let m = getLocalizedStringForObject(d.tagFormat, language, "#0.0");
                        return formatNumber(d.difference, m);
                    }
                    else {
                        return d.difference;
                    }
                }
                else if (path === "tag.unit") {
                    if (d.tagUnit) {
                        return getLocalizedStringForObject(d.tagUnit, language, "");
                    }
                    else {
                        return "";
                    }
                }
                else if (path === "tag.label") {
                    if (d.tagLabel) {
                        return getLocalizedStringForObject(d.tagLabel, language, "");
                    }
                    else {
                        return "";
                    }
                }
                else if (path === "tag.labelOrName") {
                    if (d.tagLabel) {
                        return getLocalizedStringForObject(d.tagLabel, language, "");
                    }
                    else {
                        let parts = d.id.split("#");
                        let msg = parts[0].split(".").slice(1).join(".");
                        if (parts.length > 1) {
                            if (parts[1].includes("HH")) {
                                msg = msg + " HH";
                            }
                            else if (parts[1].includes("H")) {
                                msg = msg + " HH";
                            }
                            if (parts[1].includes("LL")) {
                                msg = msg + " L";
                            }
                            else if (parts[1].includes("L")) {
                                msg = msg + " L";
                            }
                        }
                        return msg;
                    }
                }
                else if (path === "tag.note") {
                    if (d.tagNote) {
                        return getLocalizedStringForObject(d.tagNote, language, "");
                    }
                    else {
                        return "";
                    }
                }
                else if (path === "tag.name") {
                    return d.id.split("#")[0];
                }
                return match;
            });
            if (langs.length > 1) {
                finalMsg[langs[i]] = msg;
            }
            else {
                d.message = msg;
            }
        }
        if (langs.length > 1) {
            d.message = finalMsg;
        }
    }
}
//read active alarms
export async function readLiveAlarms(language, filterType, filterActions, tf, all, definition) {
    let url = "/apiv1/live/alarms/?type=getLiveAlarms";
    if (all) {
        url = url + "&filter=all";
    }
    url += "&_=" + new Date().getTime();
    let ret = null;
    try {
        let config = {
            method: "GET",
            hostname: "127.0.0.1",
            path: url,
            port: 4101,
            //mode: "cors",
            headers: {
                //  "Access-Control-Allow-Origin": "*",
                "x-tenantid": this.tenantID,
                apikey: "internalapi",
            },
        };
        try {
            ret = await _get(config);
        }
        catch (e) {
            try {
                await sleep(300);
                ret = await _get(config);
            }
            catch (e) {
                return null;
            }
        }
    }
    catch (e) { }
    if (ret && ret.data) {
        correctAlarms(ret.data, language, definition, tf);
    }
    else {
        return null;
    }
    if (filterType || filterActions) {
        let f = {
            alarm: true,
            warning: true,
            errored: true,
            active_confirmed: true,
            active_notconfirmed: true,
            active_suppresed: true,
            inactive_confirmed: true,
            inactive_notconfirmed: true,
            inactive_suppresed: true,
        };
        if (filterType) {
            f.alarm = filterType.alarm;
            f.warning = filterType.warning;
            f.errored = filterType.errored;
        }
        if (filterActions) {
            f.active_confirmed = filterActions.active_confirmed;
            f.active_notconfirmed = filterActions.active_notconfirmed;
            f.active_suppresed = filterActions.active_suppresed;
            f.inactive_confirmed = filterActions.inactive_confirmed;
            f.inactive_notconfirmed = filterActions.inactive_notconfirmed;
            f.inactive_suppresed = filterActions.inactive_suppresed;
        }
        let filtered = [];
        for (let alm of ret.data) {
            //Alarm | Warning
            if (alm.error != null) {
                if (f.errored) {
                    filtered.push(alm);
                }
            }
            else if ((!alm.warning && f.alarm) || (alm.warning && f.warning)) {
                if (alm.active) {
                    // aktivni
                    if (f.active_confirmed && alm.confirmed) {
                        filtered.push(alm);
                    }
                    else if (f.active_notconfirmed && !alm.confirmed) {
                        filtered.push(alm);
                    }
                    else if (f.active_suppresed && !alm.suppresed) {
                        filtered.push(alm);
                    }
                }
                else if (!alm.active) {
                    // neaktivni
                    if (f.inactive_confirmed && alm.confirmed) {
                        filtered.push(alm);
                    }
                    else if (f.inactive_notconfirmed && !alm.confirmed) {
                        filtered.push(alm);
                    }
                    else if (f.inactive_suppresed && !alm.suppresed) {
                        filtered.push(alm);
                    }
                }
            }
        }
        return filtered;
    }
    return ret.data;
}
//get historical alarms from system
export async function getHistoAlarms(language, from, to, limit, type, FilterType, FilterCategory, limitPerTag, ids, tfFormat) {
    let fc = [];
    if (FilterCategory) {
        fc = FilterCategory;
    }
    //let time1 = new Date().getTime();
    // posilat na /oauth pokud je uzivatel prihlasen
    let url = "/apiv1/history/";
    if (process.env.NODE_ENV === "development") {
        url = "http://localhost:4101/apiv1/history/";
    }
    url = url + "alarms?from=" + encodeURIComponent(from.toISOString());
    url = url + "&to=" + encodeURIComponent(to.toISOString());
    if (limit) {
        url = url + "&limit=" + encodeURIComponent(limit);
    }
    if (limitPerTag) {
        url = url + "&limitPerTag=" + encodeURIComponent(limitPerTag);
    }
    if (ids && ids.length > 0) {
        let idstext = "";
        for (const col of ids) {
            idstext = idstext + "&ids[]=" + encodeURIComponent(col);
        }
        url = url + idstext;
    }
    if (type && type.error) {
        url = url + "&error=true";
    }
    if (type && type.warning) {
        url = url + "&warning=true";
    }
    if (FilterType) {
        let pole = [];
        if (FilterType.Activate) {
            pole.push(0);
        }
        if (FilterType.Deactivate) {
            pole.push(1);
        }
        if (FilterType.Confirm) {
            pole.push(2);
        }
        if (FilterType.Suppress) {
            pole.push(3);
        }
        if (FilterType.Unsuppress) {
            pole.push(4);
        }
        if (FilterType.Error) {
            pole.push(5);
        }
        url = url + "&filterType=" + encodeURIComponent(pole.join("|"));
    }
    if (fc && Array.isArray(fc) && fc.length > 0) {
        url = url + "&filterCategory=" + encodeURIComponent(JSON.stringify(fc));
    }
    url += "&_=" + new Date().getTime();
    let config = {
        method: "GET",
        hostname: "127.0.0.1",
        path: url,
        port: 4101,
        //mode: "cors",
        headers: {
            //  "Access-Control-Allow-Origin": "*",
            "x-tenantid": this.tenantID,
            apikey: "internalapi",
        },
    };
    let ret = null;
    try {
        ret = await _get(config);
    }
    catch (e) {
        try {
            await sleep(300);
            ret = await _get(config);
        }
        catch (e) {
            return null;
        }
    }
    if (ret && !ret.error) {
        correctAlarms(ret, language, undefined, tfFormat);
        //spojime alarmy do skupin, tj zgrupujeme dle id
        /*
        if (group) {
          const groupedData = ret.reduce((acc: any, item: any) => {
            let status = "";
            if (item.action == 0) {
              status = "Activation";
            }
            if (item.action == 1) {
              status = "Deactivation";
            }
            if (item.action == 3) {
              status = "Confirmation";
            }
            if (item.action == 4) {
              status = "Suppressed";
            }
            if (item.action == 5) {
              status = "Unsuppressed";
            }
            if (item.action == 6) {
              status = "Errored";
            }
    
            let type = "error";
            if (item.warning) {
              type = "warning";
            }
    
            if (!acc[item.id]) {
              let unit = getLocalizedStringForObject(item.tagUnit, language, "");
    
              acc[item.id] = {
                message: item.message,
                categories: item.categories,
                type: type,
                unit: unit,
                limit: item.limit,
                history: [],
              };
            }
    
            acc[item.id].history.push({ time: item.tf, status: status, value: item.value });
            return acc;
          }, {});
    
          ret = Object.values(groupedData);
        }
        */
    }
    else {
        return null;
    }
    return ret;
}
export async function getTagStatistics(tag, from, to, statistics, limit) {
    let time1 = new Date().getTime();
    let itms = tag.split(".");
    let firstItem = itms.shift();
    if (firstItem === "0") {
    }
    else if (firstItem && this.connections != null && this.connections.name != null && this.connections.name[firstItem] != null) {
        tag = this.connections.name[firstItem] + "." + itms.join(".");
    }
    let url = "/apiv1/history/";
    url = url + "statistics?from=" + encodeURIComponent(from.toISOString());
    url = url + "&to=" + encodeURIComponent(to.toISOString());
    if (limit) {
        url = url + "&limit=" + encodeURIComponent(limit);
    }
    if (tag) {
        url = url + "&tag=" + encodeURIComponent(tag);
    }
    if (statistics) {
        url = url + "&statistics=" + encodeURIComponent(statistics);
    }
    let config = {
        method: "GET",
        hostname: "127.0.0.1",
        path: url,
        port: 4101,
        //mode: "cors",
        headers: {
            //  "Access-Control-Allow-Origin": "*",
            "x-tenantid": this.tenantID,
            apikey: "internalapi",
        },
    };
    let ret = null;
    try {
        ret = await _get(config);
    }
    catch (e) {
        try {
            await sleep(300);
            ret = await _get(config);
        }
        catch (e) {
            return null;
        }
    }
    return ret;
}
export async function getHistoricalData(tgs, from, to, _groupBy, groupByValue, customGroupBy, limit, densify, fillEndValue, fillStartValue, formatValuesLanguage, tfFormat) {
    let time1 = new Date().getTime();
    if (_groupBy === "---") {
        _groupBy = "raw";
    }
    let groupBy = _groupBy === "raw" ? "" : _groupBy;
    if (!Array.isArray(tgs)) {
        tgs = [tgs];
    }
    let tags = [];
    for (let t of tgs) {
        let itms = t.split(".");
        let firstItem = itms.shift();
        if (firstItem === "0") {
            tags.push(t);
        }
        else if (firstItem === "equations") {
            tags.push(t.replace("equations.", "0."));
        }
        else if (firstItem && this.connections != null && this.connections.name != null && this.connections.name[firstItem] != null) {
            let newTag = this.connections.name[firstItem] + "." + itms.join(".");
            tags.push(newTag);
        }
    }
    let url = "/apiv1/history/";
    url = url + "data?from=" + encodeURIComponent(from.toISOString());
    url = url + "&to=" + encodeURIComponent(to.toISOString());
    for (const t of tags) {
        url = url + "&tags[]=" + encodeURIComponent(t);
    }
    if (groupBy) {
        url = url + "&groupBy=" + encodeURIComponent(groupBy);
    }
    if (groupByValue) {
        url = url + "&groupByValue=" + encodeURIComponent(groupByValue);
    }
    if (customGroupBy) {
        for (const col of customGroupBy) {
            url = url + "&customGroupBy%5B%5D=" + encodeURIComponent(JSON.stringify(col));
        }
    }
    if (limit) {
        url = url + "&limit=" + encodeURIComponent(limit);
    }
    if (formatValuesLanguage) {
        url = url + "&formatValuesLanguage=" + encodeURIComponent(formatValuesLanguage);
    }
    if (tfFormat) {
        url = url + "&tfFormat=" + encodeURIComponent(tfFormat);
    }
    if (densify) {
        url = url + "&densify=" + encodeURIComponent(densify);
    }
    if (fillEndValue != null) {
        url = url + "&fillEndValue=" + encodeURIComponent(fillEndValue);
    }
    if (fillStartValue != null) {
        url = url + "&fillStartValue=" + encodeURIComponent(fillStartValue);
    }
    let config = {
        method: "GET",
        hostname: "127.0.0.1",
        path: url,
        port: 4101,
        //mode: "cors",
        headers: {
            //  "Access-Control-Allow-Origin": "*",
            "x-tenantid": this.tenantID,
            apikey: "internalapi",
        },
    };
    let ret = null;
    try {
        ret = await _get(config);
    }
    catch (e) {
        try {
            await sleep(300);
            ret = await _get(config);
        }
        catch (e) {
            return null;
        }
    }
    if (ret != null && ret !== false) {
        let result = {};
        for (let key in ret) {
            try {
                let itms = key.split(".");
                let firstItem = itms.shift();
                if (firstItem === "0") {
                    result[key] = ret[key];
                }
                else if (firstItem && this.connections != null && this.connections.id != null && this.connections.id[firstItem] != null) {
                    let newKey = this.connections.id[firstItem] + "." + itms.join(".");
                    result[newKey] = ret[key];
                }
            }
            catch (e) { }
        }
        if (this.singleTag) {
            for (let key in ret) {
                let value = ret[key];
                if (Array.isArray(value) && value.length === 1) {
                    return value[0];
                }
                else {
                    return value;
                }
            }
        }
        else {
            return result;
        }
    }
    let time2 = new Date().getTime();
    // console.log("Historead GET Request time [ms]:" + (time2 - time1));
    return ret;
}
export async function getHistoricalDataAsTable(tgs, from, to, _groupBy, groupByValue, customGroupBy, limit, densify, fillEndValue, fillStartValue, aggregationFunctions, tagToKeys, formatValuesLanguage, tfFormat) {
    if (_groupBy === "---") {
        _groupBy = "raw";
    }
    if (_groupBy) {
        if (!["raw", "hours", "minutes", "days"].includes(_groupBy)) {
            return null;
        }
    }
    if (aggregationFunctions) {
        if (aggregationFunctions.length !== tgs.length) {
            return null;
        }
    }
    if (tagToKeys) {
        if (tagToKeys.length !== tgs.length) {
            return null;
        }
    }
    let aggFcns = {};
    let time1 = new Date().getTime();
    let groupBy = _groupBy === "raw" ? "" : _groupBy;
    let tags = [];
    let index = 0;
    for (let _t of tgs) {
        let t = _t;
        if (_t.startsWith("equations.")) {
            t = _t.replace("equations.", "0.");
        }
        let itms = t.split(".");
        let firstItem = itms.shift();
        if (firstItem === "0") {
            tags.push(t);
            if (tagToKeys) {
                if (!aggregationFunctions) {
                    aggFcns[tagToKeys[index]] = "value";
                }
                else {
                    if (aggregationFunctions[index] === "avg") {
                        aggFcns[tagToKeys[index]] = "value";
                    }
                    else {
                        aggFcns[tagToKeys[index]] = aggregationFunctions[index];
                    }
                }
            }
            else {
                if (!aggregationFunctions) {
                    aggFcns[t] = "value";
                }
                else {
                    if (aggregationFunctions[index] === "avg") {
                        aggFcns[t] = "value";
                    }
                    else {
                        aggFcns[t] = aggregationFunctions[index];
                    }
                }
            }
        }
        else if (firstItem && this.connections != null && this.connections.name != null && this.connections.name[firstItem] != null) {
            let newTag = this.connections.name[firstItem] + "." + itms.join(".");
            tags.push(newTag);
            if (tagToKeys) {
                if (!aggregationFunctions) {
                    aggFcns[tagToKeys[index]] = "value";
                }
                else {
                    if (aggregationFunctions[index] === "avg") {
                        aggFcns[tagToKeys[index]] = "value";
                    }
                    else {
                        aggFcns[tagToKeys[index]] = aggregationFunctions[index];
                    }
                }
            }
            else {
                if (!aggregationFunctions) {
                    aggFcns[t] = "value";
                }
                else {
                    if (aggregationFunctions[index] === "avg") {
                        aggFcns[newTag] = "value";
                    }
                    else {
                        aggFcns[newTag] = aggregationFunctions[index];
                    }
                }
            }
        }
        index++;
    }
    let url = "/apiv1/history/";
    url = url + "data?from=" + encodeURIComponent(from.toISOString());
    url = url + "&to=" + encodeURIComponent(to.toISOString());
    for (const t of tags) {
        url = url + "&tags[]=" + encodeURIComponent(t);
    }
    if (groupBy) {
        url = url + "&groupBy=" + encodeURIComponent(groupBy);
    }
    if (groupByValue) {
        url = url + "&groupByValue=" + encodeURIComponent(groupByValue);
    }
    if (customGroupBy) {
        for (const col of customGroupBy) {
            url = url + "&customGroupBy%5B%5D=" + encodeURIComponent(JSON.stringify(col));
        }
    }
    if (limit) {
        url = url + "&limit=" + encodeURIComponent(limit);
    }
    if (formatValuesLanguage) {
        url = url + "&formatValuesLanguage=" + encodeURIComponent(formatValuesLanguage);
    }
    if (tfFormat) {
        url = url + "&tfFormat=" + encodeURIComponent(tfFormat);
    }
    if (densify) {
        url = url + "&densify=" + encodeURIComponent(densify);
    }
    if (fillEndValue != null) {
        url = url + "&fillEndValue=" + encodeURIComponent(fillEndValue);
    }
    if (fillStartValue != null) {
        url = url + "&fillStartValue=" + encodeURIComponent(fillStartValue);
    }
    let config = {
        method: "GET",
        hostname: "127.0.0.1",
        path: url,
        port: 4101,
        //mode: "cors",
        headers: {
            //  "Access-Control-Allow-Origin": "*",
            "x-tenantid": this.tenantID,
            apikey: "internalapi",
        },
    };
    let ret = null;
    try {
        ret = await _get(config);
    }
    catch (e) {
        try {
            await sleep(300);
            ret = await _get(config);
        }
        catch (e) {
            return null;
        }
    }
    if (ret != null && ret !== false) {
        let retConverted = {};
        for (let key in ret) {
            try {
                let itms = key.split(".");
                let firstItem = itms.shift();
                if (firstItem === "0") {
                    if (tagToKeys) {
                        for (let i = 0; i < tgs.length; i++) {
                            if (tgs[i] === key || tgs[i] === "equations." + key.substring(2)) {
                                retConverted[tagToKeys[i]] = ret[key];
                                break;
                            }
                        }
                    }
                    else {
                        retConverted[key] = ret[key];
                    }
                }
                else if (firstItem && this.connections != null && this.connections.id != null && this.connections.id[firstItem] != null) {
                    let newKey = this.connections.id[firstItem] + "." + itms.join(".");
                    if (tagToKeys) {
                        for (let i = 0; i < tgs.length; i++) {
                            if (tgs[i] === newKey) {
                                retConverted[tagToKeys[i]] = ret[key];
                                break;
                            }
                        }
                    }
                    else {
                        retConverted[newKey] = ret[key];
                    }
                }
            }
            catch (e) { }
        }
        //now we convert to table based on time;
        // Step 1: Create a Set of all unique timestamps
        const allTimestamps = new Set();
        for (const key in retConverted) {
            for (const entry of retConverted[key]) {
                allTimestamps.add(entry.tf);
            }
        }
        // Step 2: Build a map for fast access by tf
        const valueMaps = {};
        for (const key in retConverted) {
            valueMaps[key] = {};
            for (const entry of retConverted[key]) {
                valueMaps[key][entry.tf] = entry[aggFcns[key]];
            }
        }
        // Step 3: Merge into unified array
        const result = Array.from(allTimestamps)
            .sort() // optional: sort by time
            .map((tf) => {
            const merged = { tf };
            for (const key in valueMaps) {
                merged[key] = valueMaps[key][tf] ?? null; // null for missing values
            }
            return merged;
        });
        return result;
    }
    let time2 = new Date().getTime();
    // console.log("Historead GET Request time [ms]:" + (time2 - time1));
    return ret;
}
export async function sendWriteRequest(tgs) {
    let tags = {};
    let hasAny = false;
    for (let key in tgs) {
        let itms = key.split(".");
        let firstItem = itms.shift();
        if (firstItem && this.connections && this.connections.name && this.connections.name[firstItem]) {
            let newTag = this.connections.name[firstItem] + "." + itms.join(".");
            let v = tgs[key];
            if (Array.isArray(v)) {
                for (let i = 0; i < v.length; i++) {
                    if (v[i] === true) {
                        v[i] = 1;
                    }
                    else if (v[i] === false) {
                        v[i] = 0;
                    }
                }
                tags[newTag] = v;
            }
            else {
                if (v === true) {
                    v = 1;
                }
                else if (v === false) {
                    v = 0;
                }
                tags[newTag] = [v];
            }
            hasAny = true;
        }
    }
    if (hasAny) {
        let write = {
            writeData: tags,
            confirm: 0,
        };
        try {
            await _post(this.tenantID, "/apiv1/live/data", 4101, JSON.stringify(write));
            return true;
        }
        catch (e) {
            return false;
        }
    }
    return true;
}
async function dataFetch(tenantid, project, dataobj) {
    let command = dataobj.command;
    let urlarray = command.split("/");
    dataobj.command = urlarray[1];
    if (project) {
        dataobj.project = project;
    }
    let ret = await _post(tenantid, "/" + urlarray[0], 4001, JSON.stringify(dataobj));
    //pokud se nepodari vycist zkusime znovu
    if (ret === undefined) {
        await sleep(200);
        ret = await _post(tenantid, "/" + urlarray[0], 4001, JSON.stringify(dataobj));
    }
    if (ret === undefined) {
        return [true, {}];
    }
    else {
        return [false, ret];
    }
}
export async function getTagNames(connection, f, limit) {
    if ((this.connections == undefined || this.connections.name) == undefined || this.connections.name[connection] == undefined) {
        return { err: true, message: "Connection does not exist." };
    }
    let connId = this.connections.name[connection];
    let filter = connId + ".";
    let [err, ret] = await dataFetch(this.tenantID, this.project, {
        command: "db/tagsStartsWith",
        filter: filter,
        data: { limit: limit, customFilter: f },
    });
    if (ret) {
        //we need to convert 1.tag to conn.tag
        let retConverted = [];
        for (let t of ret) {
            let itms = t.split(".");
            let firstItem = itms.shift();
            if (firstItem && this.connections && this.connections.id && this.connections.id[firstItem]) {
                let newTag = this.connections.id[firstItem] + "." + itms.join(".");
                retConverted.push(newTag);
            }
            else if (firstItem == "0") {
                retConverted.push(t);
            }
        }
        return retConverted;
    }
    else {
        return [];
    }
}
export async function removeTags(tgs) {
    let tags = [];
    for (let tag of tgs) {
        let itms = tag.split(".");
        let firstItem = itms.shift();
        if (firstItem && this.connections !== undefined && this.connections.name !== undefined && this.connections.name[firstItem] !== undefined) {
            let newTag = this.connections.name[firstItem] + "." + itms.join(".");
            tags.push(newTag);
        }
    }
    if (tags.length > 0) {
        await dataFetch(this.tenantID, this.project, {
            command: "db/removeTags",
            data: { keys: tags },
        });
    }
    else {
        return false;
    }
}
export async function removeTagsStartingWith(connection, f) {
    if ((this.connections == undefined || this.connections.name == undefined || this.connections.name[connection]) == undefined) {
        return { err: true, message: "Connection does not exist." };
    }
    let connId = this.connections.name[connection];
    let filter = connId + "." + f;
    let [err, ret] = await dataFetch(this.tenantID, this.project, {
        command: "db/removeKeysWithPattern",
        key: filter,
    });
    return ret;
}
export async function addTag(tagname, data) {
    let itms = tagname.split(".");
    let firstItem = itms.shift();
    if (firstItem && this.connections !== undefined && this.connections.name !== undefined && this.connections.name[firstItem] !== undefined) {
        let newTag = this.connections.name[firstItem] + "." + itms.join(".");
        let [err, ret] = await dataFetch(this.tenantID, this.project, {
            command: "db/addTag",
            data: data,
            key: newTag,
        });
        return ret;
    }
    return false;
}
function _notify(_prefix, notificationGroup, definitions, alarms, title, body, file) {
    let groupDef = definitions.groups[notificationGroup];
    if (!groupDef) {
        for (let g of definitions.groups) {
            if (g.id === notificationGroup) {
                groupDef = g;
            }
        }
    }
    if (groupDef) {
        if (!groupDef.message) {
            groupDef.message = {
                deflang: "en",
                body: {},
                subject: {},
            };
        }
        if (!groupDef.message.deflang) {
            groupDef.message.deflang = "en";
        }
        if (!groupDef.message.body) {
            groupDef.message.body = {};
        }
        if (!groupDef.message.subject) {
            groupDef.message.subject = {};
        }
        let getMessage = (lang) => {
            let message = groupDef.message.body[lang];
            if (!message) {
                message = groupDef.message.body[groupDef.message.deflang];
            }
            if (typeof body === "string") {
                message = body;
            }
            else if (body && body[lang]) {
                message = body[lang];
            }
            if (alarms != null && !message) {
                message = "{alarms}";
            }
            if (alarms != null && message.includes("{alarms}")) {
                let newAlarms = JSON.parse(JSON.stringify(alarms));
                correctAlarms([newAlarms], lang);
                let alarmMsg = newAlarms.message;
                message = message.replaceAll("{alarms}", alarmMsg);
            }
            if (!message) {
                message = "";
            }
            return message;
        };
        let getSubject = (lang) => {
            let message = groupDef.message.subject[lang];
            if (!message) {
                message = groupDef.message.subject[groupDef.message.deflang];
            }
            if (typeof title === "string") {
                message = title;
            }
            else if (title && title[lang]) {
                message = title[lang];
            }
            if (alarms != null && !message) {
                message = "Alarm Activations";
            }
            if (!message) {
                message = "";
            }
            return message;
        };
        let getFile = (lang) => {
            if (!file) {
                return undefined;
            }
            if (typeof file === "string") {
                return file;
            }
            let f = file[lang];
            if (f) {
                return f;
            }
            let f2 = file[groupDef.message.deflang];
            if (f2) {
                return f2;
            }
            let keys = Object.keys(file);
            if (keys.length > 0) {
                return file[keys[0]];
            }
            return undefined;
        };
        let users = definitions.users;
        for (let data of groupDef.data) {
            let url = data.url;
            let groups = data.groups;
            let _users = data.users;
            let done = false;
            if ((url.includes("{email}") || url.includes("{phone}")) && groups && groups.length > 0) {
                // /users.current;
                for (let u of users) {
                    let hasSame = u.group.some((item) => groups.includes(item));
                    if (hasSame) {
                        let lang = groupDef.message.deflang;
                        if (u.lang) {
                            lang = u.lang;
                        }
                        let body = getMessage(lang);
                        let subject = getSubject(lang);
                        let _file = getFile(lang);
                        if (url.includes("{email}") && u.email) {
                            done = true;
                            let newurl = url.replaceAll("{email}", u.email);
                            let o = { url: newurl, title: subject, body: body };
                            if (_file) {
                                o.attach = _file;
                            }
                            notifyObj(_prefix, o);
                        }
                        else if (url.includes("{phone}") && u.tel) {
                            done = true;
                            let newurl = url.replaceAll("{phone}", u.tel);
                            let o = { url: newurl, title: subject, body: body };
                            if (_file) {
                                o.attach = _file;
                            }
                            notifyObj(_prefix, o);
                        }
                    }
                }
            }
            if ((url.includes("{email}") || url.includes("{phone}")) && _users && _users.length > 0) {
                // /users.current;
                for (let u of users) {
                    let hasSame = _users.includes(u.id);
                    if (hasSame) {
                        let lang = groupDef.message.deflang;
                        if (u.lang) {
                            lang = u.lang;
                        }
                        let body = getMessage(lang);
                        let subject = getSubject(lang);
                        let _file = getFile(lang);
                        if (url.includes("{email}") && u.email) {
                            done = true;
                            let newurl = url.replaceAll("{email}", u.email);
                            let o = { url: newurl, title: subject, body: body };
                            if (_file) {
                                o.attach = _file;
                            }
                            notifyObj(_prefix, o);
                        }
                        else if (url.includes("{phone}") && u.tel) {
                            done = true;
                            let newurl = url.replaceAll("{phone}", u.tel);
                            let o = { url: newurl, title: subject, body: body };
                            if (_file) {
                                o.attach = _file;
                            }
                            notifyObj(_prefix, o);
                        }
                    }
                }
            }
            if (!done) {
                let body2 = getMessage(groupDef.message.deflang);
                let subject = getSubject(groupDef.message.deflang);
                let o = { url: url, title: subject, body: body2 };
                let _file = getFile(groupDef.message.deflang);
                if (_file) {
                    o.attach = _file;
                }
                notifyObj(_prefix, o);
            }
        }
    }
}
export function stripMarkdown(markdown) {
    return (markdown
        // Remove headers (e.g., # Heading)
        .replace(/^#{1,6}\s+/gm, "")
        // Remove bold (**text** or __text__)
        .replace(/(\*\*|__)(.*?)\1/g, "$2")
        // Remove italic (*text* or _text_)
        .replace(/(\*|_)(.*?)\1/g, "$2")
        // Remove inline code (`code`)
        .replace(/`([^`]+)`/g, "$1")
        // Remove links but keep text [text](url)
        .replace(/\[([^\]]+)\]\([^)]+\)/g, "$1")
        // Remove images ![alt](url)
        .replace(/!\[.*?\]\(.*?\)/g, "")
        // Remove blockquotes
        .replace(/^\s*>+\s?/gm, "")
        // Remove horizontal rules
        .replace(/^[-*_]{3,}$/gm, "")
        // Remove lists (*, -, +)
        .replace(/^\s*([-*+]|\d+\.)\s+/gm, "")
        // Remove remaining formatting characters
        .replace(/\\([*_`~])/g, "$1")
        // Remove extra spaces
        .replace(/\s{2,}/g, " ")
        .trim());
}
export function markdownToWordXml(markdownText) {
    const md = new MarkdownIt();
    const tokens = md.parseInline(markdownText, {})[0].children ?? [];
    const result = [];
    const currentStyle = {};
    for (const token of tokens) {
        switch (token.type) {
            case "text":
                result.push(makeRun(token.content, currentStyle));
                break;
            case "strong_open":
                currentStyle.bold = true;
                break;
            case "strong_close":
                currentStyle.bold = false;
                break;
            case "em_open":
                currentStyle.italic = true;
                break;
            case "em_close":
                currentStyle.italic = false;
                break;
            case "softbreak":
            case "hardbreak":
                result.push("||<w:br/>||");
                break;
        }
    }
    return result.join("");
}
function makeRun(text, style) {
    const props = [];
    if (style.bold)
        props.push("<w:b/>");
    if (style.italic)
        props.push("<w:i/>");
    return '||<w:r xmlns:w="http://schemas.openxmlformats.org/wordprocessingml/2006/main">' + `<w:rPr>${props.join("")}</w:rPr>` + `<w:t>${escapeXml(text)}</w:t>` + "</w:r>||";
}
function escapeXml(str) {
    return str.replace(/[<>&'"]/g, (c) => ({
        "<": "&lt;",
        ">": "&gt;",
        "&": "&amp;",
        "'": "&apos;",
        '"': "&quot;",
    }[c] ?? c));
}
export async function searchUsingAI(_prefix, question, _lang, history, chatID) {
    try {
        let lang = _lang;
        if (this.language) {
            lang = this.language;
        }
        let object = {
            lang: lang,
            message: question,
            chatid: chatID,
            history: history,
        };
        let prefix = _prefix;
        if (this.tenantID) {
            prefix = this.tenantID;
        }
        //let url = "/apiAI/chat/";
        //let url = "apiv1/ai/chat/";
        let port = 4501;
        //let port = 4101;
        let url = "/search";
        let reply = await _post(prefix, url, port, JSON.stringify(object));
        return reply;
    }
    catch (e) {
        return "?";
    }
}
export async function chatWithAI(_prefix, question, _lang, history, chatID, output) {
    try {
        let lang = _lang;
        if (this.language) {
            lang = this.language;
        }
        let object = {
            lang: lang,
            message: question,
            chatid: chatID,
        };
        let prefix = _prefix;
        if (this.tenantID) {
            prefix = this.tenantID;
        }
        //let url = "apiv1/ai/chat/";
        //let port = 4101;
        let port = 4501;
        let url = "/chat";
        let reply = await _post(prefix, url, port, JSON.stringify(object));
        if (reply && reply.message) {
            if (output === "text") {
                reply.message = stripMarkdown(reply.message);
            }
            if (output === "docx") {
                reply.message = markdownToWordXml(reply.message);
            }
            return reply.message;
        }
        else {
            return "";
        }
    }
    catch (e) {
        console.log(e);
        console.error(e);
        return "?";
    }
}
export async function searchAI(prefix, question) {
    try {
        let object = {
            message: question,
        };
        let reply = await _post(prefix, "/notify", 4601, JSON.stringify(object));
        return reply;
    }
    catch (e) {
        return { err: true, message: e };
    }
}
export function notifyObj(prefix, object) {
    setTimeout(async () => {
        if (object.url.startsWith("modemsms://")) {
            try {
                let parts = object.url.split("//");
                let o = {
                    phone: parts[1],
                    sms: object.body,
                };
                await _post(prefix, "/notify", 4801, JSON.stringify(o), "host.docker.internal");
                return true;
            }
            catch (e) {
                return false;
            }
        }
        else {
            try {
                await _post(prefix, "/notify", 4601, JSON.stringify(object));
                return true;
            }
            catch (e) {
                return false;
            }
        }
    }, 1);
}
export function notifyReport(_prefix, notificationGroup, definitions, title, body, file) {
    _notify(_prefix, notificationGroup, definitions, null, title, body, file);
}
export function notifyAlarms(_prefix, notificationGroup, definitions, alarms, title, body, file) {
    _notify(_prefix, notificationGroup, definitions, alarms, title, body);
}
export async function notify(_prefix, group, title, body, file) {
    _notify(this.tenantID, group, this.notificationGroupDefinitions, null, title, body, file);
    /*
    let prefix = this.tenantID;
    if (_prefix) {
      prefix = _prefix;
    }
    let write: any = {
      body: body,
      title: title,
      prefix: prefix + "",
      id: group,
    };
  
    if (file) {
      write.attach = file;
    }
  
    try {
      await _post(prefix, "/notify", 4601, JSON.stringify(write));
      return true;
    } catch (e) {
      return false;
    }
      */
    return true;
}
export async function liveDataGet(tgs) {
    if (!Array.isArray(tgs)) {
        tgs = [tgs];
    }
    let _tags = [];
    if (this.connections) {
        for (let t of tgs) {
            let itms = t.split(".");
            let firstItem = itms.shift();
            if (firstItem === "0") {
                _tags.push(t);
            }
            else if (firstItem === "equations") {
                let newTag = "0." + itms.join(".");
                _tags.push(newTag);
            }
            else if (firstItem && this.connections != null && this.connections.name != null && this.connections.name[firstItem] != null) {
                let newTag = this.connections.name[firstItem] + "." + itms.join(".");
                _tags.push(newTag);
            }
        }
    }
    else {
        _tags = tgs;
    }
    let tags = stripArrayTags(_tags);
    let url = "/apiv1/";
    url = url + "live/data/?";
    let tagstext = "";
    for (const col of tags) {
        if (tagstext) {
            tagstext = tagstext + "&";
        }
        tagstext = tagstext + "tags[]=" + encodeURIComponent(col);
    }
    url = url + tagstext + "&_=" + new Date().getTime();
    let ret = null;
    try {
        let config = {
            method: "GET",
            hostname: "127.0.0.1",
            path: url,
            port: 4101,
            //mode: "cors",
            headers: {
                //  "Access-Control-Allow-Origin": "*",
                "x-tenantid": this.tenantID,
                apikey: "internalapi",
            },
        };
        try {
            ret = await _get(config);
        }
        catch (e) {
            try {
                await sleep(300);
                ret = await _get(config);
            }
            catch (e) {
                return null;
            }
        }
        if (ret && ret.data && Object.keys(ret.data).length !== tgs.length) {
            await sleep(100);
            ret = await _get(config);
        }
        if (ret && ret.data && Object.keys(ret.data).length !== tgs.length) {
            await sleep(300);
            ret = await _get(config);
        }
    }
    catch (e) { }
    // console.log("Live data GET Request time [ms]:" + (time2 - time1));
    if (ret && ret.data) {
        let ts = tagsToArrayTags(_tags, ret.data);
        if (this.connections) {
            //we need to convert 1.tag to conn.tag
            let retConverted = {};
            for (let t in ts) {
                let itms = t.split(".");
                let firstItem = itms.shift();
                if (firstItem && this.connections && this.connections.id && this.connections.id[firstItem]) {
                    let newTag = this.connections.id[firstItem] + "." + itms.join(".");
                    retConverted[newTag] = ts[t];
                }
                else if (firstItem == "0") {
                    let newTag = "equations" + "." + itms.join(".");
                    retConverted[newTag] = ts[t];
                }
            }
            if (this.singleTag) {
                for (let key in retConverted) {
                    let value = retConverted[key];
                    if (Array.isArray(value) && value.length === 1) {
                        return value[0];
                    }
                    else {
                        return value;
                    }
                }
            }
            else {
                return retConverted;
            }
        }
        else {
            if (this.singleTag) {
                for (let key in ts) {
                    let value = ts[key];
                    if (Array.isArray(value) && value.length === 1) {
                        return value[0];
                    }
                    else {
                        return value;
                    }
                }
            }
            else {
                return ts;
            }
        }
    }
    if (this.singleTag && ret.data) {
        for (let key in ret.data) {
            try {
                let value = ret.data[key].value;
                if (Array.isArray(value) && value.length === 1) {
                    return value[0];
                }
                else {
                    return value;
                }
            }
            catch (e) {
                return null;
            }
        }
    }
    else {
        return ret;
    }
    return ret;
}
export // Define the sleep function
 function sleep(ms) {
    return new Promise((resolve) => setTimeout(resolve, ms));
}
export async function codeTableGet(name, view, filter, type, returnType, lang, limit, orderBy, columns) {
    let time1 = new Date().getTime();
    let url = "/apiv1/";
    url = url + "codetable?name=" + encodeURIComponent(name);
    if (view) {
        if (view === "__default_view__") {
            url = url + "&view=" + encodeURIComponent("fulldata");
        }
        else {
            url = url + "&view=" + encodeURIComponent(view);
        }
    }
    if (type) {
        url = url + "&type=" + encodeURIComponent(type);
    }
    if (filter) {
        let filt = "";
        let index = 0;
        for (const f of filter) {
            index++;
            if (filt.length === 0) {
                filt = JSON.stringify(f);
            }
            else {
                if (index === 1) {
                    filt = "filter[]=" + JSON.stringify(f);
                }
                else {
                    filt = JSON.stringify(f);
                }
            }
            url = url + "&filter%5B%5D=" + encodeURIComponent(filt);
        }
    }
    if (columns) {
        for (const col of columns) {
            url = url + "&columns%5B%5D=" + encodeURIComponent(col);
        }
    }
    if (limit) {
        url = url + "&limit=" + encodeURIComponent(limit);
    }
    if (orderBy) {
        url = url + "&orderBy=" + encodeURIComponent(orderBy);
    }
    if (returnType) {
        url = url + "&returnType=" + encodeURIComponent(returnType);
    }
    if (lang) {
        url = url + "&lang=" + encodeURIComponent(lang);
    }
    let config = {
        method: "GET",
        hostname: "127.0.0.1",
        path: url,
        port: 4101,
        //mode: "cors",
        headers: {
            //  "Access-Control-Allow-Origin": "*",
            "x-tenantid": this.tenantID,
            apikey: "internalapi",
        },
    };
    let ret = null;
    try {
        ret = await _get(config);
    }
    catch (e) {
        try {
            await sleep(300);
            ret = await _get(config);
        }
        catch (e) {
            return { err: true, message: "Timeout" };
        }
    }
    if (ret && ret.data) {
        return ret.data;
    }
    else {
        return { err: true, message: "No Data" };
    }
}
export function getLocalizedText(lang, data, deftxt) {
    if (data == null) {
        if (deftxt) {
            return deftxt;
        }
        return "";
    }
    if (typeof data === "string") {
        return data;
    }
    let label = data[lang];
    if (!label) {
        label = data["en"];
    }
    if (!label) {
        let klice = Object.keys(data);
        if (klice && klice.length > 0) {
            label = data[klice[0]];
        }
    }
    if (!label) {
        if (deftxt) {
            return deftxt;
        }
        label = "";
    }
    return label;
}
//# sourceMappingURL=data:application/json;base64,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