"use strict";
// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE file in the project root for full license information.
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExternalEventTracker = void 0;
class ExternalEventTracker {
    constructor(emitter) {
        this._listenerContainer = new Map();
        this._emitter = emitter;
    }
    addTrackedListener(eventName, listener) {
        this._emitter.addListener(eventName, listener);
        if (this._listenerContainer.has(eventName)) {
            this._listenerContainer.get(eventName).push(listener);
        }
        else {
            this._listenerContainer.set(eventName, [listener]);
        }
    }
    removeTrackedListener(eventName, listener) {
        const listeners = this._listenerContainer.get(eventName);
        const index = listeners === null || listeners === void 0 ? void 0 : listeners.indexOf(listener);
        if (listeners === undefined || index === -1)
            return;
        if (listeners.length === 1) {
            this._listenerContainer.delete(eventName);
        }
        else {
            listeners.splice(index, 1);
        }
        this._emitter.removeListener(eventName, listener);
    }
    removeAllTrackedListeners(eventName) {
        var _a;
        const eventsToRemove = eventName ? [eventName] : this._listenerContainer.keys();
        for (const event of eventsToRemove) {
            for (const listener of ((_a = this._listenerContainer.get(event)) !== null && _a !== void 0 ? _a : [])) {
                this._emitter.removeListener(event, listener);
            }
            this._listenerContainer.delete(event);
        }
    }
}
exports.ExternalEventTracker = ExternalEventTracker;
//# sourceMappingURL=external_event_tracker.js.map