"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CursorReqBody = exports.PipelineReqBody = void 0;
const protobuf_encode_js_1 = require("../shared/protobuf_encode.js");
const util_js_1 = require("../util.js");
function PipelineReqBody(w, msg) {
    if (msg.baton !== undefined) {
        w.string(1, msg.baton);
    }
    for (const req of msg.requests) {
        w.message(2, req, StreamRequest);
    }
}
exports.PipelineReqBody = PipelineReqBody;
function StreamRequest(w, msg) {
    if (msg.type === "close") {
        w.message(1, msg, CloseStreamReq);
    }
    else if (msg.type === "execute") {
        w.message(2, msg, ExecuteStreamReq);
    }
    else if (msg.type === "batch") {
        w.message(3, msg, BatchStreamReq);
    }
    else if (msg.type === "sequence") {
        w.message(4, msg, SequenceStreamReq);
    }
    else if (msg.type === "describe") {
        w.message(5, msg, DescribeStreamReq);
    }
    else if (msg.type === "store_sql") {
        w.message(6, msg, StoreSqlStreamReq);
    }
    else if (msg.type === "close_sql") {
        w.message(7, msg, CloseSqlStreamReq);
    }
    else if (msg.type === "get_autocommit") {
        w.message(8, msg, GetAutocommitStreamReq);
    }
    else {
        throw (0, util_js_1.impossible)(msg, "Impossible type of StreamRequest");
    }
}
function CloseStreamReq(_w, _msg) {
}
function ExecuteStreamReq(w, msg) {
    w.message(1, msg.stmt, protobuf_encode_js_1.Stmt);
}
function BatchStreamReq(w, msg) {
    w.message(1, msg.batch, protobuf_encode_js_1.Batch);
}
function SequenceStreamReq(w, msg) {
    if (msg.sql !== undefined) {
        w.string(1, msg.sql);
    }
    if (msg.sqlId !== undefined) {
        w.int32(2, msg.sqlId);
    }
}
function DescribeStreamReq(w, msg) {
    if (msg.sql !== undefined) {
        w.string(1, msg.sql);
    }
    if (msg.sqlId !== undefined) {
        w.int32(2, msg.sqlId);
    }
}
function StoreSqlStreamReq(w, msg) {
    w.int32(1, msg.sqlId);
    w.string(2, msg.sql);
}
function CloseSqlStreamReq(w, msg) {
    w.int32(1, msg.sqlId);
}
function GetAutocommitStreamReq(_w, _msg) {
}
function CursorReqBody(w, msg) {
    if (msg.baton !== undefined) {
        w.string(1, msg.baton);
    }
    w.message(2, msg.batch, protobuf_encode_js_1.Batch);
}
exports.CursorReqBody = CursorReqBody;
