import { type BaseMessage, type BaseMessageChunk } from "@langchain/core/messages";
import type { Message } from "../types.messages.js";
export declare class MessageTupleManager {
    chunks: Record<string, {
        chunk?: BaseMessageChunk | BaseMessage;
        metadata?: Record<string, unknown>;
        index?: number;
    }>;
    constructor();
    add(serialized: Message, metadata: Record<string, unknown> | undefined): string | null;
    clear(): void;
    get(id: string | null | undefined, defaultIndex?: number): {
        chunk?: BaseMessageChunk | BaseMessage;
        metadata?: Record<string, unknown>;
        index?: number;
    } | null;
}
export declare const toMessageDict: (chunk: BaseMessage) => Message;
