"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.toMessageDict = exports.MessageTupleManager = void 0;
const messages_1 = require("@langchain/core/messages");
function tryConvertToChunk(message) {
    try {
        return (0, messages_1.convertToChunk)(message);
    }
    catch {
        return null;
    }
}
function tryCoerceMessageLikeToMessage(message) {
    // TODO: this is unnecessary with https://github.com/langchain-ai/langchainjs/pull/8941
    if (message.type === "remove" && message.id != null) {
        return new messages_1.RemoveMessage({ ...message, id: message.id });
    }
    return (0, messages_1.coerceMessageLikeToMessage)(message);
}
class MessageTupleManager {
    constructor() {
        Object.defineProperty(this, "chunks", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: {}
        });
        this.chunks = {};
    }
    add(serialized, metadata) {
        // TODO: this is sometimes sent from the API
        // figure out how to prevent this or move this to LC.js
        if (serialized.type.endsWith("MessageChunk")) {
            // eslint-disable-next-line no-param-reassign
            serialized.type = serialized.type
                .slice(0, -"MessageChunk".length)
                .toLowerCase();
        }
        const message = tryCoerceMessageLikeToMessage(serialized);
        const chunk = tryConvertToChunk(message);
        const { id } = chunk ?? message;
        if (!id) {
            console.warn("No message ID found for chunk, ignoring in state", serialized);
            return null;
        }
        this.chunks[id] ??= {};
        this.chunks[id].metadata = metadata ?? this.chunks[id].metadata;
        if (chunk) {
            const prev = this.chunks[id].chunk;
            this.chunks[id].chunk =
                ((0, messages_1.isBaseMessageChunk)(prev) ? prev : null)?.concat(chunk) ?? chunk;
        }
        else {
            this.chunks[id].chunk = message;
        }
        return id;
    }
    clear() {
        this.chunks = {};
    }
    get(id, defaultIndex) {
        if (id == null)
            return null;
        if (this.chunks[id] == null)
            return null;
        if (defaultIndex != null)
            this.chunks[id].index ??= defaultIndex;
        return this.chunks[id];
    }
}
exports.MessageTupleManager = MessageTupleManager;
const toMessageDict = (chunk) => {
    const { type, data } = chunk.toDict();
    return { ...data, type };
};
exports.toMessageDict = toMessageDict;
