"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StreamError = void 0;
class StreamError extends Error {
    constructor(data) {
        super(data.message);
        this.name = data.name ?? data.error ?? "StreamError";
    }
    static isStructuredError(error) {
        return typeof error === "object" && error != null && "message" in error;
    }
}
exports.StreamError = StreamError;
