import type { BagTemplate, GetUpdateType, GetConfigurableType, UseStreamCustomOptions, UseStreamCustom, UseStreamTransport } from "./types.js";
import { Command } from "../types.js";
interface FetchStreamTransportOptions {
    /**
     * The URL of the API to use.
     */
    apiUrl: string;
    /**
     * Default headers to send with requests.
     */
    defaultHeaders?: HeadersInit;
    /**
     * Specify a custom fetch implementation.
     */
    fetch?: typeof fetch | ((...args: any[]) => any);
    /**
     * Callback that is called before the request is made.
     */
    onRequest?: (url: string, init: RequestInit) => Promise<RequestInit> | RequestInit;
}
export declare class FetchStreamTransport<StateType extends Record<string, unknown> = Record<string, unknown>, Bag extends BagTemplate = BagTemplate> implements UseStreamTransport<StateType, Bag> {
    private readonly options;
    constructor(options: FetchStreamTransportOptions);
    stream(payload: {
        input: GetUpdateType<Bag, StateType> | null | undefined;
        context: GetConfigurableType<Bag> | undefined;
        command: Command | undefined;
        signal: AbortSignal;
    }): Promise<AsyncGenerator<{
        id?: string;
        event: string;
        data: unknown;
    }>>;
}
export declare function useStreamCustom<StateType extends Record<string, unknown> = Record<string, unknown>, Bag extends {
    ConfigurableType?: Record<string, unknown>;
    InterruptType?: unknown;
    CustomEventType?: unknown;
    UpdateType?: unknown;
} = BagTemplate>(options: UseStreamCustomOptions<StateType, Bag>): UseStreamCustom<StateType, Bag>;
export {};
