"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.useStream = useStream;
const react_1 = require("react");
const stream_lgp_js_1 = require("./stream.lgp.cjs");
const stream_custom_js_1 = require("./stream.custom.cjs");
function isCustomOptions(options) {
    return "transport" in options;
}
function useStream(options) {
    // Store this in useState to make sure we're not changing the implementation in re-renders
    const [isCustom] = (0, react_1.useState)(isCustomOptions(options));
    if (isCustom) {
        // eslint-disable-next-line react-hooks/rules-of-hooks
        return (0, stream_custom_js_1.useStreamCustom)(options);
    }
    // eslint-disable-next-line react-hooks/rules-of-hooks
    return (0, stream_lgp_js_1.useStreamLGP)(options);
}
