import { AuthActionErrorBase } from "../../AuthFlowErrorBase.js";
/**
 * Error that occurred during MFA challenge request.
 */
export declare class MfaRequestChallengeError extends AuthActionErrorBase {
    /**
     * Checks if the input for MFA challenge is incorrect.
     * @returns true if the input is incorrect, false otherwise.
     */
    isInvalidInput(): boolean;
}
/**
 * Error that occurred during MFA challenge submission.
 */
export declare class MfaSubmitChallengeError extends AuthActionErrorBase {
    /**
     * Checks if the submitted challenge code (e.g., OTP code) is incorrect.
     * @returns true if the challenge code is invalid, false otherwise.
     */
    isIncorrectChallenge(): boolean;
}
//# sourceMappingURL=MfaError.d.ts.map