import path from "path";
import url from "url";
import express from "express"; // eslint-disable-line import/no-unresolved
import helmet from "helmet";
import { fileURLToPath } from "url";
import { promises as fs } from "fs";
import Provider from "oidc-provider";
//import { Configuration } from "oidc-provider";
//import * as adapter from "./adapters/mongodb";
//TODO vycistit
//import Account from "./accountExpress";
import configuration from "./configuration.js";
import routes from "./routesExpress.js";
//pro user autentifikaci
import { MongoClient } from "mongodb";
//const mongoUrl = "mongodb://127.0.0.1:27017/?tls=true";
const __filename = fileURLToPath(import.meta.url);
const __dirname = path.dirname(__filename);
let { PORT = 4201, HOST = "127.0.0.1", MONGOURL = "mongodb://127.0.0.1:27017/?tls=true", ISSUER = `http://${HOST}:${PORT}` } = process.env;
const app = express();
const directives = helmet.contentSecurityPolicy.getDefaultDirectives();
delete directives["form-action"];
app.use((req, res, next) => {
    //osetreni // na zacatku url
    req.url = req.url.replace(/^\/{2}/, "/");
    req.originalUrl = req.originalUrl.replace(/^\/{2}/, "/");
    //pokud referer obsahuje prefix ulozim do baseUrl
    const match = req.headers.referer?.match(/.+:\/\/[^\/]+\/([^\/]+)\/?/);
    if (match) {
        //ulozeni baseUrl
        if (req.headers["referer"])
            req.baseUrl = req.headers["referer"];
        //odstraneni koncoveho /
        req.baseUrl = req.baseUrl.replace(/\/$/, "");
    }
    next();
});
/*
app.use(
  helmet({
    contentSecurityPolicy: {
      directives: {
        defaultSrc: ["'self'"],
        scriptSrc: ["'self'", "'unsafe-inline'"],
        styleSrc: ["'self'", "'unsafe-inline'"],
        imgSrc: ["'self'", "data:"],
        fontSrc: ["'self'", "https:", "data:"],
        connectSrc: ["'self'", "https://oauth2.googleapis.com"], // or your OAuth token endpoint
        frameSrc: ["'self'", "https://accounts.google.com"], // for embedded auth windows
      },
    },
    crossOriginOpenerPolicy: { policy: "same-origin" },
    crossOriginEmbedderPolicy: { policy: "require-corp" },
    crossOriginResourcePolicy: { policy: "same-origin" },
    originAgentCluster: true,
    referrerPolicy: { policy: "no-referrer" },
    xPermittedCrossDomainPolicies: { permittedPolicies: "none" },
  })
);
*/
//umozneni debugu
app.use(helmet({
    //TODO projit co opravdu potrebujeme
    //https://github.com/helmetjs/helmet?tab=readme-ov-file#content-security-policy
    contentSecurityPolicy: {
        directives: {},
        reportOnly: true,
    },
    crossOriginOpenerPolicy: false,
    crossOriginResourcePolicy: false,
    originAgentCluster: false,
    referrerPolicy: false,
    xPermittedCrossDomainPolicies: false,
}));
app.set("views", path.join(__dirname, "views"));
app.set("view engine", "ejs");
//vycteni info o uzivatelich
const certFile = process.env.cert || "/data/certs/mongod/client/client.pem";
let sleep = (ms) => {
    return new Promise((resolve) => setTimeout(resolve, ms));
};
let config = { user: "admin", password: "admin" };
try {
    let _config = await fs.readFile("/data/conf/mongodbconf.json", "utf-8");
    config = JSON.parse(_config);
}
catch (e) { }
MONGOURL = `mongodb://${config.user}:${config.password}@127.0.0.1:27017/?tls=true`;
let mongoConfig = {
    serverSelectionTimeoutMS: 5000,
    tlsCertificateKeyFile: certFile,
    tlsAllowInvalidCertificates: true,
};
if (process.env.debug) {
    mongoConfig.directConnection = true;
}
var dbClient = new MongoClient(MONGOURL, mongoConfig);
//konec user info
let server;
async function dbConnect() {
    try {
        await dbClient.connect();
        console.log("MongoDB client connected.");
        return true;
    }
    catch (e) {
        console.log("MongoDB client connection error:" + e.message);
        return false;
    }
}
(async () => {
    /*let adapter;
    if (process.env.MONGODB_URI) {
    //adapter = require("./adapters/mongodb"); // eslint-disable-line global-require
      await adapter.connect();
    }*/
    const prod = process.env.NODE_ENV === "production";
    //pripojeni k db kvuli nacteni user info
    let connected = await dbConnect();
    while (!connected) {
        await sleep(5000);
        connected = await dbConnect();
    }
    //middleware na parsovani user info
    let getUsers = async () => {
        if (connected) {
            //TODO vyresit multitenant
            let db = dbClient.db("1_project");
            let f = { _id: "users" };
            let data = await db.collection("project").findOne(f);
            if (data) {
                delete data._id;
            }
            if (data && data.data) {
                //  global.users = data.data;
                console.log("Users loaded");
                let obj = app;
                obj.__users = data.data;
            }
        }
    };
    let getTenants = async () => {
        if (connected) {
            //TODO vyresit multitenant
            let db = dbClient.db("global");
            let f = { _id: "tenants" };
            let data = await db.collection("global").findOne(f);
            if (data) {
                delete data._id;
            }
            if (data && data.data) {
                //  global.users = data.data;
                console.log("Tenants loaded");
                let obj = app;
                obj.__tenants = data.data;
            }
        }
    };
    await getTenants();
    setInterval(async () => {
        await getUsers();
        await getTenants();
    }, 30000);
    getUsers();
    //konec user info
    const provider = new Provider(ISSUER, { ...configuration });
    if (prod) {
        app.enable("trust proxy");
        provider.proxy = true;
        app.use((req, res, next) => {
            if (req.secure) {
                next();
            }
            else if (req.method === "GET" || req.method === "HEAD") {
                res.redirect(url.format({
                    protocol: "https",
                    host: req.get("host"),
                    pathname: req.originalUrl,
                }));
            }
            else {
                res.status(400).json({
                    error: "invalid_request",
                    error_description: "do yourself a favor and only use https",
                });
            }
        });
    }
    //povoleni vsech redirect uri - bezpecnostni riziko
    provider.Client.prototype.redirectUriAllowed = function allowAll(uri) {
        return true;
    };
    routes(app, provider);
    app.use(provider.callback());
    provider.use(async (ctx, next) => {
        /** pre-processing
         * you may target a specific action here by matching `ctx.path`
         */
        await next();
        //doplneni hashe z cloudu do cesty
        if (ctx.oidc?.route == "authorization") {
            //pokud referer obsahuje prefix pridam prefix do cookies
            const match = ctx.oidc?.ctx?.request?.headers?.referer?.match(/.+:\/\/[^\/]+\/([^\/]+)\/?/);
            if (match) {
                //uprava redirectu
                ctx.oidc.ctx.set("Location", ctx.oidc.ctx.response.headers.location.replace(/\/interaction\//g, ctx.oidc.ctx.request.headers.referer + "interaction/"));
                ctx.oidc.ctx.body = ctx.oidc.ctx.body.replace(/\/interaction\//g, ctx.oidc.ctx.request.headers.referer + "interaction/");
                let prefix = match[1];
                // Read the existing cookie
                const setCookies = ctx.response.headers["set-cookie"];
                for (let cookie of setCookies) {
                    // pokud
                    const match2 = cookie.match(/_interaction=([^;]+);/);
                    if (match2) {
                        //nacteni puvodniho hashe
                        const origCookieValue = match2[1];
                        //vypneni nive cesty s prefixem
                        const newPath = prefix + "/interaction/" + origCookieValue; // The new path you want for the cookie
                        // Set the cookie again with the new path
                        ctx.oidc.ctx.cookies.set("_interaction", origCookieValue, {
                            httpOnly: true, // Keep the httpOnly flag to make it inaccessible to JavaScript
                            secure: false,
                            maxAge: 1000 * 60 * 60 * 1, // Expires in 1 hour
                            path: newPath, // Modify the path to the new path
                            sameSite: "lax", // Retain sameSite setting
                        });
                        break;
                    }
                }
            }
        }
        //tady doplnim groups a tenantID
        if (ctx.oidc?.route == "introspection") {
            let obj = app;
            //nastaveni tenantID pro anon i prihlasene uzivatele
            let tenantID = "1"; //default hodnota
            if (obj.__tenants && ctx.request.headers["tenantname"]) {
                for (let idx in obj.__tenants) {
                    if (obj.__tenants[idx].name == ctx.request.headers["tenantname"]) {
                        tenantID = obj.__tenants[idx].id;
                        break;
                    }
                }
            }
            ctx.response.body["tenantId"] = tenantID;
            if (ctx.response.body["active"]) {
                if (obj.__users) {
                    for (let user of obj.__users) {
                        if (user.name == ctx.response.body["sub"]) {
                            ctx.response.body["groups"] = user.group;
                            ctx.response.body["designer"] = user.designer;
                            break;
                        }
                    }
                }
            }
        }
    });
    server = app.listen(PORT, HOST, () => {
        console.log(`application is listening on port ${PORT}, check its /.well-known/openid-configuration`);
    });
})().catch((err) => {
    if (server?.listening)
        server.close();
    console.error(err);
    process.exitCode = 1;
});
