"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
module.exports = function (liveDataService) {
    let operations = {
        GET,
    };
    function GET(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            let prefix = req.prefix.replace("_", "");
            let result = yield liveDataService.sendReport(prefix, req.query);
            if (result.err) {
                if (result.msg == "Timeout")
                    res.status(408).json(result);
                else
                    res.status(400).json(result);
            }
            else
                res.status(200).json(result);
        });
    }
    GET.apiDoc = {
        tags: ["Reporting"],
        summary: "Generate Report.",
        operationId: "generateReport",
        parameters: [
            {
                name: "name",
                in: "query",
                description: "Report name",
                required: true,
                schema: {
                    type: "string",
                },
            },
            {
                name: "from",
                in: "query",
                description: "Start datetime value in format RFC 3339, section 5.6 (example: 2017-07-21T17:32:28Z)",
                required: false,
                schema: {
                    type: "string",
                    format: "date-time", //2017-07-21T17:32:28Z
                },
            },
            {
                name: "to",
                in: "query",
                description: "End datetime value in format RFC 3339, section 5.6 (example: 2017-07-21T17:32:28Z)",
                required: false,
                schema: {
                    type: "string",
                    format: "date-time",
                },
            },
            {
                name: "limit",
                in: "query",
                description: "Limit number of records",
                required: false,
                schema: {
                    type: "integer",
                    minimum: 1,
                },
            },
            {
                name: "filename",
                in: "query",
                description: "Output file name",
                required: false,
                schema: {
                    type: "string",
                },
            },
            {
                name: "options",
                in: "query",
                description: "Pass data for script.",
                required: false,
                schema: {},
            },
        ],
        responses: {
            200: {
                description: "TODO...",
                content: {
                    "*/*": {
                        schema: {
                            type: "object",
                            items: {
                                $ref: "#/components/schemas/ReportingResult",
                            },
                        },
                    },
                },
            },
            408: {
                description: "Timeout occured",
                content: {
                    "application/json": {
                        schema: {
                            $ref: "#/components/schemas/ErrMsg",
                        },
                        example: {
                            err: true,
                            msg: "Timeout",
                        },
                    },
                },
            },
            400: {
                description: "Error occured",
                content: {
                    "application/json": {
                        schema: {
                            $ref: "#/components/schemas/ErrMsg",
                        },
                        example: {
                            err: true,
                            msg: "Error Message",
                        },
                    },
                },
            },
            401: {
                description: "Unauthorized",
                content: {
                    "application/json": {
                        schema: {
                            $ref: "#/components/schemas/ErrMsg",
                        },
                        example: {
                            err: true,
                            msg: "API token invalid.",
                        },
                    },
                },
            },
        },
    };
    return operations;
};
//# sourceMappingURL=index.js.map