"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
module.exports = function (liveDataService) {
    let operations = {
        GET,
        POST,
    };
    function GET(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            let result;
            //TODO nacist a overit usera a tenantID z api
            let q = { tags: req.query.tags };
            //default TTL z API -1 - vycist pouze jednou a odebrat
            let ttl = -1;
            if (req.query.ttl)
                ttl = req.query.ttl;
            result = yield liveDataService.getLiveData(q, req.groups, "1", "api", ttl);
            res.status(200).json(result);
        });
    }
    function POST(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            //TODO nacist a overit usera a tenantID z api
            let result = yield liveDataService.writeLiveData(req.body, req.groups, "1", "api", "API");
            res.status(200).json(result);
        });
    }
    GET.apiDoc = {
        tags: ["Live Data"],
        summary: "Get live data",
        operationId: "readLiveData",
        parameters: [
            {
                name: "tags",
                in: "query",
                description: 'Array of tag names eg. ["1.tag1","global memory.tag1"]',
                required: true,
                schema: {
                    type: "array",
                    items: {
                        type: "string",
                    },
                    example: ["1.tag1", "global memory.tag1"],
                    minItems: 1,
                },
            },
            {
                name: "ttl",
                in: "query",
                description: "TTL of tags in seconds (0 continual, -1 oneshot), default -1",
                required: false,
                schema: {
                    type: "integer",
                },
            },
            {
                name: "timeout",
                in: "query",
                description: "How long to wait for the complete data in milliseconds",
                required: false,
                schema: {
                    type: "integer",
                },
            },
        ],
        responses: {
            200: {
                description: "Array of live data.",
                content: {
                    "application/json": {
                        schema: {
                            type: "object",
                            properties: {
                                data: {
                                    additionalProperties: {
                                        oneOf: [
                                            {
                                                type: "array",
                                                items: {
                                                    $ref: "#/components/schemas/LiveDataNum",
                                                },
                                                minItems: 1,
                                                example: [[1.24, 3.1416], [2.56]],
                                            },
                                            {
                                                type: "array",
                                                items: {
                                                    $ref: "#/components/schemas/LiveDataStr",
                                                },
                                                minItems: 1,
                                                example: [["value1.1", "value1.2"], ["value2"]],
                                            },
                                        ],
                                    },
                                    example: [{ "1.tag1": { value: [1.25] } }, { "1.tag2": { value: ["testString"] } }, { "1.tag3": { error: "Tag not found in tag DB" } }],
                                },
                            },
                        },
                    },
                },
            },
            401: {
                description: "Unauthorized",
                content: {
                    "application/json": {
                        schema: {
                            $ref: "#/components/schemas/ErrMsg",
                        },
                        example: {
                            err: true,
                            msg: "API token invalid.",
                        },
                    },
                },
            },
        },
    };
    POST.apiDoc = {
        tags: ["Live Data"],
        summary: "Set live data",
        operationId: "writeLiveData",
        requestBody: {
            required: true,
            content: {
                "application/json": {
                    schema: {
                        type: "object",
                        properties: {
                            writeData: {
                                type: "object",
                                additionalProperties: {
                                    $ref: "#/components/schemas/strOrNumArray",
                                },
                                example: {
                                    "1.tag1": [1.25],
                                    "1.tag2": ["testString"],
                                },
                            },
                            confirm: {
                                type: "number",
                            },
                        },
                        required: ["writeData"],
                    },
                },
            },
        },
        responses: {
            200: {
                description: "Optional confirmation of each tag (1 = write OK, 2 = Error)",
                content: {
                    "application/json": {
                        schema: {
                            type: "object",
                            properties: {
                                written: {
                                    type: "array",
                                    items: {
                                        type: "integer",
                                    },
                                    example: "[0,1]",
                                },
                            },
                        },
                    },
                },
            },
            401: {
                description: "Unauthorized",
                content: {
                    "application/json": {
                        schema: {
                            $ref: "#/components/schemas/ErrMsg",
                        },
                        example: {
                            err: true,
                            msg: "API token invalid.",
                        },
                    },
                },
            },
        },
    };
    return operations;
};
//# sourceMappingURL=index.js.map