"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
module.exports = function (liveDataService) {
    let operations = {
        GET,
    };
    function GET(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            let result;
            //zpracovani pozadavku na alarmy
            if (req.query.type && req.query.type == "getLiveAlarms") {
                result = yield liveDataService.getLiveAlarms(req.query, req.groups, "1", "api");
                if (!result.error)
                    res.status(200).json(result);
                else
                    res.status(400).json({ err: true, msg: result.error });
            }
            else {
                res.status(405).json({ err: true, msg: "Unknown type: " + req.query.type });
            }
        });
    }
    GET.apiDoc = {
        tags: ["Live Data"],
        summary: "Get live alarms",
        operationId: "getLiveAlarms",
        parameters: [
            {
                name: "type",
                in: "query",
                schema: {
                    type: "string",
                    enum: ["getLiveAlarms"],
                    default: "getLiveAlarms",
                },
            },
        ],
        responses: {
            200: {
                description: "Array of alarms.",
                content: {
                    "application/json": {
                        schema: {
                            properties: {
                                tf: {
                                    type: "string",
                                    format: "date-time",
                                },
                                type: { type: "string" },
                                data: {
                                    type: "array",
                                    items: {},
                                },
                                uuid: { type: "string" },
                            },
                        },
                        example: {
                            tf: "2025-07-05T12:12:12.547Z",
                            type: "alarmList",
                            data: [
                                {
                                    id: "3.memint###limit._custom.HH",
                                    tf: "2025-07-05T11:59:26.708Z",
                                    message: {
                                        cs: "Test Alarm Message",
                                    },
                                    value: 5,
                                    difference: 0,
                                    limit: 10,
                                    active: false,
                                    suppresed: false,
                                    confirmed: false,
                                    warning: false,
                                    tagUnit: {},
                                    tagFormat: {
                                        cs: "#0",
                                    },
                                    tagNote: {},
                                    access: [],
                                    categories: [],
                                    action: 1,
                                    actTime: "2025-07-05T11:46:23.356Z",
                                    _id: "6869109073ace33ff1b8a236",
                                    deActTime: "2025-07-05T11:59:26.708Z",
                                },
                            ],
                            uuid: "16e07c6a-b3b6-4882-bbde-d64fa9cdca6e",
                        },
                    },
                },
            },
            400: {
                description: "General error",
                content: {
                    "application/json": {
                        schema: {
                            $ref: "#/components/schemas/ErrMsg",
                        },
                        example: {
                            err: true,
                            msg: "Get live alarms timeout",
                        },
                    },
                },
            },
            401: {
                description: "Unauthorized",
                content: {
                    "application/json": {
                        schema: {
                            $ref: "#/components/schemas/ErrMsg",
                        },
                        example: {
                            err: true,
                            msg: "API token invalid.",
                        },
                    },
                },
            },
            405: {
                description: "Unknown type",
                content: {
                    "application/json": {
                        schema: {
                            $ref: "#/components/schemas/ErrMsg",
                        },
                        example: {
                            err: true,
                            msg: "Unknown type: test",
                        },
                    },
                },
            },
        },
    };
    return operations;
};
//# sourceMappingURL=index.js.map