"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
module.exports = function (codetablesMongoService, codetablesMSSqlService) {
    let operations = {
        POST,
    };
    function POST(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            if (globalThis.configCodetables && globalThis.configCodetables.mssql) {
                let result = yield codetablesMSSqlService.changeCodeTableConfig(req.prefix, req.body);
                res.status(200).json(result);
            }
            else {
                res.status(401);
            }
        });
    }
    POST.apiDoc = {
        tags: ["Frontend Codetables"],
        summary: "Check or set code table definitions",
        operationId: "changeCodeTableConfig",
        requestBody: {
            required: true,
            content: {
                "application/json": {
                    schema: {
                        type: "object",
                        properties: {
                            command: {
                                type: "string",
                                enum: ["checkTables", "createTables", "getCodetableConfigs"],
                            },
                        },
                        required: ["command"],
                    },
                },
            },
        },
        responses: {
            200: {
                description: "Array of live data.",
                content: {
                    "*/*": {
                        schema: {
                            type: "object",
                        },
                    },
                },
            },
            401: {
                description: "Unauthorized",
                content: {
                    "application/json": {
                        schema: {
                            $ref: "#/components/schemas/ErrMsg",
                        },
                        example: {
                            err: true,
                            msg: "API token invalid.",
                        },
                    },
                },
            },
            default: {
                description: "An error occurred",
                content: {
                    "text/html": {
                        schema: {
                            additionalProperties: true,
                        },
                    },
                },
            },
        },
    };
    return operations;
};
//# sourceMappingURL=index.js.map