"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const apiDoc = {
    openapi: "3.0.3",
    // swagger: "3.0",
    //basePath: "/",
    info: {
        title: "mySCADA API",
        version: "1.0.0",
    },
    servers: [{ url: "/apiv1" }],
    components: {
        securitySchemes: {
            /*basicAuth: {
              type: "http",
              scheme: "basic",
            },
            bearerAuth: {
              type: "http",
              scheme: "bearer",
            },*/
            apiKeyAuth: {
                type: "apiKey",
                in: "header",
                name: "X-API-Key",
            },
            oAuth2: {
                type: "oauth2",
                flows: {
                    authorizationCode: {
                        authorizationUrl: "/auth",
                        tokenUrl: "/token",
                        scopes: {
                            openid: "default OpenID",
                            myscada: "mySCADA",
                        },
                    },
                },
            },
        },
        schemas: {
            HistoricalData: {
                type: "object",
                properties: {
                    tag: {
                        type: "string",
                    },
                    datetime: {
                        type: "string",
                    },
                    value: {
                        type: "number",
                    },
                },
                required: ["tag", "datetime", "value"],
            },
            LiveDataNum: {
                type: "object",
                properties: {
                    tag: {
                        type: "string",
                    },
                    value: {
                        type: "array",
                        items: {
                            type: "number",
                        },
                    },
                },
                required: ["tag", "value"],
            },
            LiveDataStr: {
                type: "object",
                properties: {
                    tag: {
                        type: "string",
                    },
                    value: {
                        type: "array",
                        items: {
                            type: "string",
                        },
                    },
                },
                required: ["tag", "value"],
            },
            writeResponse: {
                type: "object",
                properties: {
                    tag: {
                        type: "string",
                    },
                    status: {
                        type: "number",
                    },
                },
                required: ["tag", "status"],
            },
            strOrNumArray: {
                oneOf: [
                    {
                        type: "array",
                        items: {
                            type: "number",
                        },
                        minItems: 1,
                    },
                    {
                        type: "array",
                        items: {
                            type: "string",
                        },
                        minItems: 1,
                    },
                ],
            },
            CodeTableChangeData: {
                type: "object",
                properties: {
                    update: {
                        $ref: "#/components/schemas/CodeTableArray",
                    },
                    insert: {
                        $ref: "#/components/schemas/CodeTableArray",
                    },
                    delete: {
                        type: "array",
                        items: { type: "string" },
                        uniqueItems: true,
                    },
                },
            },
            CodeTableArray: {
                type: "array",
                items: {
                    type: "object",
                    additionalProperties: true,
                },
            },
            ReportingResult: {
                type: "object",
            },
            AiResult: {
                type: "object",
                properties: {
                    err: {
                        type: "boolean",
                    },
                    message: {
                        type: "string",
                    },
                    sources: {
                        type: "array",
                        items: {
                            type: "object",
                            properties: {
                                source: { type: "string" },
                                loaderId: { type: "string" },
                            },
                        },
                    },
                },
            },
            ErrMsg: {
                properties: {
                    err: { type: "boolean" },
                    msg: { type: "string" },
                },
            },
        },
    },
    paths: {},
    security: [
        {
            apiKeyAuth: [],
        },
        { oAuth2: ["openID", "myscada"] },
    ],
};
module.exports = apiDoc;
//# sourceMappingURL=api-doc.js.map