import { interactionPolicy } from "oidc-provider";
const { Prompt } = interactionPolicy;
// copies the default policy, already has login and consent prompt policies
const interactions = interactionPolicy.base();
// create a requestable prompt with no implicit checks
const selectAccount = new Prompt({
    name: "select_account",
    requestable: true,
});
// add to index 0, order goes select_account > login > consent
interactions.add(selectAccount, 0);
const configuration = {
    clients: [
        {
            client_id: "myscadaFrontend",
            client_secret: "bar",
            grant_types: ["refresh_token", "authorization_code"],
            redirect_uris: [
                "https://oauth.pstmn.io/v1/callback",
                "https://oauthdebugger.com/debug",
                "http://localhost/callback",
                "http://localhost:3001/callback",
                "https://localhost:3001/callback",
                "http://127.0.0.1/callback",
                "https://localhost/callback",
                "https://127.0.0.1/callback",
            ],
            response_types: ["code"],
            //token_endpoint_auth_method: "none",
        },
        {
            client_id: "myscadaFrontendImplicit",
            //client_secret: "bar",
            grant_types: ["implicit"],
            redirect_uris: ["https://oauth.pstmn.io/v1/callback", "https://oauthdebugger.com/debug"],
            token_endpoint_auth_method: "none",
            response_types: ["id_token"],
            /*client_id: 'myscadaFrontend',
                grant_types: ['implicit'],
                response_types: ['id_token'],
                redirect_uris: ['https://127.0.0.1/'],
                token_endpoint_auth_method: 'none'*/
        },
    ],
    /*interactions: {
          url(ctx, interaction) { // eslint-disable-line no-unused-vars
            return `/interaction/${interaction.uid}`;
          },
        },*/
    cookies: {
        long: { signed: true }, // 1 day in ms
        short: { signed: true },
        keys: ["some secret key", "and also the old rotated away some time ago", "and one more"],
    },
    claims: {
        address: ["address"],
        email: ["email", "email_verified"],
        phone: ["phone_number", "phone_number_verified"],
        profile: [
            "birthdate",
            "family_name",
            "gender",
            "given_name",
            "locale",
            "middle_name",
            "name",
            "nickname",
            "picture",
            "preferred_username",
            "profile",
            "updated_at",
            "website",
            "zoneinfo",
        ],
        myscada: ["groups", "designer"],
    },
    features: {
        devInteractions: { enabled: false }, // defaults to true
        introspection: { enabled: true },
        deviceFlow: { enabled: true }, // defaults to false
        revocation: { enabled: true }, // defaults to false
        backchannelLogout: { enabled: true },
    },
    routes: {
        authorization: "/auth",
        code_verification: "/device",
        device_authorization: "/device/auth",
        end_session: "/session/end",
        introspection: "/token/introspection",
        jwks: "/jwks",
        pushed_authorization_request: "/request",
        registration: "/reg",
        revocation: "/token/revocation",
        token: "/token",
        userinfo: "/me",
    },
    scopes: ["openid", "offline_access", "myscada"],
    jwks: {
        keys: [
            {
                d: "VEZOsY07JTFzGTqv6cC2Y32vsfChind2I_TTuvV225_-0zrSej3XLRg8iE_u0-3GSgiGi4WImmTwmEgLo4Qp3uEcxCYbt4NMJC7fwT2i3dfRZjtZ4yJwFl0SIj8TgfQ8ptwZbFZUlcHGXZIr4nL8GXyQT0CK8wy4COfmymHrrUoyfZA154ql_OsoiupSUCRcKVvZj2JHL2KILsq_sh_l7g2dqAN8D7jYfJ58MkqlknBMa2-zi5I0-1JUOwztVNml_zGrp27UbEU60RqV3GHjoqwI6m01U7K0a8Q_SQAKYGqgepbAYOA-P4_TLl5KC4-WWBZu_rVfwgSENwWNEhw8oQ",
                dp: "E1Y-SN4bQqX7kP-bNgZ_gEv-pixJ5F_EGocHKfS56jtzRqQdTurrk4jIVpI-ZITA88lWAHxjD-OaoJUh9Jupd_lwD5Si80PyVxOMI2xaGQiF0lbKJfD38Sh8frRpgelZVaK_gm834B6SLfxKdNsP04DsJqGKktODF_fZeaGFPH0",
                dq: "F90JPxevQYOlAgEH0TUt1-3_hyxY6cfPRU2HQBaahyWrtCWpaOzenKZnvGFZdg-BuLVKjCchq3G_70OLE-XDP_ol0UTJmDTT-WyuJQdEMpt_WFF9yJGoeIu8yohfeLatU-67ukjghJ0s9CBzNE_LrGEV6Cup3FXywpSYZAV3iqc",
                e: "AQAB",
                kty: "RSA",
                n: "xwQ72P9z9OYshiQ-ntDYaPnnfwG6u9JAdLMZ5o0dmjlcyrvwQRdoFIKPnO65Q8mh6F_LDSxjxa2Yzo_wdjhbPZLjfUJXgCzm54cClXzT5twzo7lzoAfaJlkTsoZc2HFWqmcri0BuzmTFLZx2Q7wYBm0pXHmQKF0V-C1O6NWfd4mfBhbM-I1tHYSpAMgarSm22WDMDx-WWI7TEzy2QhaBVaENW9BKaKkJklocAZCxk18WhR0fckIGiWiSM5FcU1PY2jfGsTmX505Ub7P5Dz75Ygqrutd5tFrcqyPAtPTFDk8X1InxkkUwpP3nFU5o50DGhwQolGYKPGtQ-ZtmbOfcWQ",
                p: "5wC6nY6Ev5FqcLPCqn9fC6R9KUuBej6NaAVOKW7GXiOJAq2WrileGKfMc9kIny20zW3uWkRLm-O-3Yzze1zFpxmqvsvCxZ5ERVZ6leiNXSu3tez71ZZwp0O9gys4knjrI-9w46l_vFuRtjL6XEeFfHEZFaNJpz-lcnb3w0okrbM",
                q: "3I1qeEDslZFB8iNfpKAdWtz_Wzm6-jayT_V6aIvhvMj5mnU-Xpj75zLPQSGa9wunMlOoZW9w1wDO1FVuDhwzeOJaTm-Ds0MezeC4U6nVGyyDHb4CUA3ml2tzt4yLrqGYMT7XbADSvuWYADHw79OFjEi4T3s3tJymhaBvy1ulv8M",
                qi: "wSbXte9PcPtr788e713KHQ4waE26CzoXx-JNOgN0iqJMN6C4_XJEX-cSvCZDf4rh7xpXN6SGLVd5ibIyDJi7bbi5EQ5AXjazPbLBjRthcGXsIuZ3AtQyR0CEWNSdM7EyM5TRdyZQ9kftfz9nI03guW3iKKASETqX2vh0Z8XRjyU",
                use: "sig",
            },
            {
                crv: "P-256",
                d: "K9xfPv773dZR22TVUB80xouzdF7qCg5cWjPjkHyv7Ws",
                kty: "EC",
                use: "sig",
                x: "FWZ9rSkLt6Dx9E3pxLybhdM6xgR5obGsj5_pqmnz5J4",
                y: "_n8G69C-A2Xl4xUW2lF0i8ZGZnk_KPYrhv4GbTGu5G4",
            },
        ],
    },
    ttl: {
        AccessToken: 7 * 24 * 60 * 60, // 7 days in seconds
        AuthorizationCode: 7 * 24 * 60 * 60, // 7 days in seconds
        IdToken: 7 * 24 * 60 * 60, // 7 days in seconds
        DeviceCode: 10 * 60, // 10 minutes in seconds
        RefreshToken: 7 * 24 * 60 * 60, // 7 days in seconds
    },
    //vypnuti vynuceni PKCE
    pkce: {
        required(ctx, client) {
            return false;
        },
    },
    //preskoceni authorizace uz jiz vydanych grantu, nebu u grantu z myscadaFrontend
    async loadExistingGrant(ctx) {
        const grantId = ctx.oidc.result?.consent?.grantId || (ctx.oidc.client && ctx.oidc.session?.grantIdFor(ctx.oidc.client.clientId));
        if (grantId) {
            // keep grant expiry aligned with session expiry
            // to prevent consent prompt being requested when grant expires
            const grant = await ctx.oidc.provider.Grant.find(grantId);
            // this aligns the Grant ttl with that of the current session
            // if the same Grant is used for multiple sessions, or is set
            // to never expire, you probably do not want this in your code
            //if (grant && ctx.oidc.account && grant.exp && ctx.oidc.session && grant.exp < ctx.oidc.session.exp) {
            //  grant.exp = ctx.oidc.session.exp;
            // await grant.save();
            //}
            return grant;
            //pokud je to pozadavek z frontendu - nastavim granty bez consentu
        }
        else if (ctx.oidc.client?.clientId == "myscadaFrontend") {
            const grant = new ctx.oidc.provider.Grant({
                clientId: ctx.oidc.client?.clientId,
                accountId: ctx.oidc.session?.accountId,
            });
            grant.addOIDCScope("openid myscada profile");
            //TODO TADY bude potreba pridat groupy do claims, nebo tam nekam
            grant.addOIDCClaims(["name", "groups", "designer"]);
            grant.addResourceScope("urn:example:resource-indicator", "api:read api:write");
            await grant.save();
            return grant;
        }
    },
    //povoleni vsech cors
    clientBasedCORS(ctx, origin, client) {
        // ctx.oidc.route can be used to exclude endpoints from this behaviour, in that case just return
        // true to always allow CORS on them, false to deny
        // you may also allow some known internal origins if you want to
        return true;
    },
    async findAccount(ctx, id) {
        return {
            accountId: id,
            async claims(use, scope) {
                let ret = { sub: id };
                //TODO zjistit ze to tady jde nacitat
                // ret["groups"] = ["test"];
                // ret["designer"] = true;
                return ret;
            },
        };
    },
};
export default configuration;
