"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpenAi = void 0;
const debug_1 = __importDefault(require("debug"));
const openai_1 = require("@langchain/openai");
const base_model_1 = require("../../interfaces/base-model");
class OpenAi extends base_model_1.BaseModel {
    //private model: ChatOpenAI;
    constructor(configuration) {
        super(configuration.temperature);
        this.configuration = configuration;
        this.debug = (0, debug_1.default)("embedjs:model:OpenAi");
    }
    async init() {
        this.llm = new openai_1.ChatOpenAI(this.configuration);
    }
    async runQuery(messages, callback) {
        this.debug("Executing OpenAI model with prompt -", messages[messages.length - 1].content);
        if (callback) {
            const stream = await this.llm.stream(messages);
            const chunks = [];
            for await (const chunk of stream) {
                if (chunk.content != null) {
                    chunks.push(chunk.content);
                    callback(chunk.content);
                }
                else {
                    chunks.push(chunk);
                    callback(chunk);
                }
            }
            let res = chunks.join("");
            return {
                result: res,
            };
        }
        else {
            const result = await this.llm.invoke(messages);
            this.debug("OpenAI response -", result);
            return {
                result: result.content.toString(),
                tokenUse: {
                    inputTokens: result.response_metadata.tokenUsage.promptTokens,
                    outputTokens: result.response_metadata.tokenUsage.completionTokens,
                },
            };
        }
    }
}
exports.OpenAi = OpenAi;
