"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TextLoader = void 0;
const textsplitters_1 = require("@langchain/textsplitters");
const md5_1 = __importDefault(require("md5"));
const base_loader_1 = require("../interfaces/base-loader");
const rag_tools_1 = require("../rag-tools");
class TextLoader extends base_loader_1.BaseLoader {
    constructor({ type, source, text, chunkSize, chunkOverlap }) {
        let id = `${type}_${(0, md5_1.default)(text)}`;
        super(type, source, id, chunkSize ?? 300, chunkOverlap ?? 0);
        this.text = text;
    }
    async *getUnfilteredChunks() {
        const chunker = new textsplitters_1.RecursiveCharacterTextSplitter({
            chunkSize: this.chunkSize,
            chunkOverlap: this.chunkOverlap,
        });
        const chunks = await chunker.splitText((0, rag_tools_1.cleanString)(this.text));
        for (const chunk of chunks) {
            yield {
                pageContent: chunk,
                metadata: {
                    type: "TextLoader",
                    source: this.source,
                    textId: this.uniqueId,
                },
            };
        }
    }
}
exports.TextLoader = TextLoader;
