"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CsvLoader = void 0;
const csv_parse_1 = require("csv-parse");
const debug_1 = __importDefault(require("debug"));
const node_fs_1 = __importDefault(require("node:fs"));
const md5_1 = __importDefault(require("md5"));
const base_loader_1 = require("../interfaces/base-loader");
const rag_tools_1 = require("../rag-tools");
class CsvLoader extends base_loader_1.BaseLoader {
    constructor({ type, source, filePathOrUrl, csvParseOptions, chunkOverlap, chunkSize, }) {
        super(type, source, `csv_${(0, md5_1.default)(filePathOrUrl)}`, chunkSize ?? 1000, chunkOverlap ?? 0);
        this.debug = (0, debug_1.default)("embedjs:loader:CsvLoader");
        this.filePathOrUrl = filePathOrUrl;
        this.isUrl = (0, rag_tools_1.isValidURL)(filePathOrUrl) ? true : false;
        this.csvParseOptions = csvParseOptions ?? { autoParse: true };
    }
    async *getUnfilteredChunks() {
        const buffer = this.isUrl ? (await (0, rag_tools_1.getSafe)(this.filePathOrUrl, { format: "buffer" })).body : await (0, rag_tools_1.streamToBuffer)(node_fs_1.default.createReadStream(this.filePathOrUrl));
        this.debug("CsvParser stream created");
        const parser = (0, csv_parse_1.parse)(buffer, this.csvParseOptions);
        this.debug("CSV parsing started...");
        for await (const record of parser) {
            yield {
                pageContent: (0, rag_tools_1.cleanString)(record.join(",")),
                metadata: {
                    type: "CsvLoader",
                    source: this.filePathOrUrl,
                },
            };
        }
        this.debug(`CsvParser for filePathOrUrl '${this.filePathOrUrl}' finished`);
    }
}
exports.CsvLoader = CsvLoader;
