"use strict";
// scadaHelpers.ts
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
const commfunctions = __importStar(require("commfunctions"));
const tools_1 = require("../../tools");
// ---------------- SCADA Helpers (Class) ----------------
class ScadaHelpers {
    constructor(configObj, tenantId, embeddingModel, llm, vectorDB) {
        this.lang = "en";
        this.configObj = configObj;
        this.tenantId = tenantId;
        this.embeddingModel = embeddingModel;
        this.vectorDB = vectorDB;
        this.llm = llm;
    }
    setLang(lang) {
        this.lang = lang;
    }
    async getTagDefinitions(tags) {
        let tgs = await this.configObj.emmbedingsObject.getTagDefinitionsForTags(tags);
        let ret = {};
        for (let tag of tgs) {
            ret[tag._id] = tag;
        }
        return ret;
    }
    getSystemStatusMessage(alarms) {
        let result = (0, tools_1.getTranslation)(this.lang, "NO ALARM ACTIVE");
        if (alarms.length > 0) {
        }
        return result;
    }
    /**
     * Search SCADA documentation (vector store or DB)
     */
    async searchDocs(query, topK = 5) {
        const queryEmbedded = await this.embeddingModel.embedQuery(query);
        let _docs = await this.vectorDB.similaritySearch(queryEmbedded, topK, 3, "doc");
        let docs = [];
        for (let doc of _docs) {
            if (docs.length >= topK) {
                break;
            }
            if (doc.score < 0.1 && docs.length == 0) {
                return ["No documents found.", []];
            }
            docs.push({ id: doc.metadata.source.split("/")[doc.metadata.source.split("/").length - 1], text: doc.pageContent, score: Math.round(doc.score * 100) / 100 });
        }
        return [JSON.stringify(docs), docs];
    }
    /**
     * Read live SCADA tags
     */
    async getLiveTags(input) {
        let tagIDs = [];
        if (input.tags && input.tags.length > 0 && input.tags[0] !== "tags") {
            tagIDs = await this.getIds(input.tags, "tag");
        }
        else {
            return ["Specify what tags you want to read.", []];
        }
        if (tagIDs.length < 1) {
            return ["Specify what tags you want to read.", []];
        }
        let ldgFcn = commfunctions.liveDataGet.bind({ tenantID: this.tenantId });
        //process ktere tagy chceme vycist
        let liveTags = await ldgFcn(tagIDs);
        let emb = "### " + (0, tools_1.getKey)(this.lang, "live") + " ###\n" + (0, tools_1.formatLiveValues)(this.lang, this.tenantId, this.configObj, liveTags, await this.getTagDefinitions(Object.keys(liveTags)));
        return [emb, { tagIDs: tagIDs }];
    }
    /**
     * Query historical SCADA data
     */
    async getHistory(input) {
        let tagIDs = [];
        if (input.tags && input.tags.length > 0 && input.tags[0] !== "tags") {
            tagIDs = await this.getIds(input.tags, "tag");
        }
        else {
            return ["Specify what tags to you want to read.", { tagIDs: [] }];
        }
        let to = new Date();
        let from = new Date(to.getTime() - 7 * 1000 * 60 * 60 * 24);
        if (input.from) {
            try {
                from = new Date(input.from);
            }
            catch (e) { }
        }
        if (input.to) {
            try {
                to = new Date(input.to);
            }
            catch (e) { }
        }
        let lalFcn = commfunctions.getTagStatistics.bind({ tenantID: this.tenantId });
        let tgs = {};
        for (let tag of tagIDs) {
            let tagStats = await lalFcn(tag, from, to);
            tgs[tag] = tagStats;
            // result = result + "\n" + JSON.stringify(tagStats);
        }
        //let emb =
        //"### " + getKey(this.lang, "live") + " ###\n" +
        let emb = (0, tools_1.formatTagStatistics)(this.lang, this.tenantId, this.configObj, tgs, await this.getTagDefinitions(Object.keys(tgs)));
        return [emb, { tagIDs: tagIDs }];
        //return result;
    }
    /**
     * Get live alarms
     */
    async getAlarms(input, overview) {
        let alarmIDs = [];
        if (!overview && input.alarms && input.alarms.length > 0 && input.alarms[0] !== "alarms") {
            alarmIDs = await this.getIds(input.alarms, "alarm");
        }
        const alarmLimit = input.limit ? input.limit : 100;
        let result = "";
        let lalFcn = commfunctions.readLiveAlarms.bind({ tenantID: this.tenantId });
        let liveAlarms = await lalFcn(this.lang);
        let liveAlarmsCopy = JSON.parse(JSON.stringify(liveAlarms));
        if (liveAlarms) {
            if (liveAlarms.length === 0) {
                result = result + (0, tools_1.getTranslation)(this.lang, "NO ALARM ACTIVE");
                if (overview)
                    return [result, { alarmIDs: [], alarms: [] }];
            }
            else {
                //nejdrive setridime
                // Define priority function
                // Define priority function
                const getPriority = (alarm) => {
                    if (alarm.active) {
                        return alarm.confirmed ? 1 : 0; // Active & unconfirmed first, then active & confirmed
                    }
                    return 2; // Inactive alarms last
                };
                liveAlarms.sort((a, b) => {
                    const priorityA = getPriority(a);
                    const priorityB = getPriority(b);
                    // Sort by priority first
                    if (priorityA !== priorityB) {
                        return priorityA - priorityB;
                    }
                    // If priorities are the same, sort by warning (false first)
                    return a.warning - b.warning;
                });
                //pokud je vice nez x alarmu a existuji konkretni alarmy profiltrujeme
                let active = 0;
                let confirmed = 0;
                for (let i = 0; i < liveAlarms.length; i++) {
                    if (liveAlarms[i].active && !liveAlarms[i].confirmed) {
                        active++;
                    }
                    else if (liveAlarms[i].active && liveAlarms[i].confirmed) {
                        confirmed++;
                    }
                }
                let txt = (0, tools_1.getTranslation)(this.lang, "ALARM ACTIVE, CONFIRMED");
                txt = txt.replace("{0}", active + "");
                txt = txt.replace("{1}", confirmed + "");
                result = result + "\n" + txt;
                if (overview)
                    return [result, { alarmIDs: alarmIDs, alarms: liveAlarmsCopy }];
                if (alarmIDs.length > 0) {
                    for (let i = liveAlarms.length - 1; i >= 0; i--) {
                        let id = (0, tools_1.returnAlarmID)(liveAlarms[i].id);
                        if (!alarmIDs.includes(id)) {
                            liveAlarms.splice(i, 1);
                        }
                    }
                }
                if (liveAlarms.length > alarmLimit) {
                    liveAlarms.splice(0, alarmLimit);
                }
                if (liveAlarms.length > 0) {
                    let emb = "### " + (0, tools_1.getKey)(this.lang, "liveAlarms") + " ###\n";
                    emb = emb + (0, tools_1.formatLiveAlarms)(this.configObj, this.tenantId, this.lang, liveAlarms);
                    result = result + emb;
                }
            }
        }
        return [result, { alarmIDs: alarmIDs, alarms: liveAlarmsCopy }];
    }
    async getIds(tags, type) {
        let limit = tags.length * 2;
        if (limit < 10) {
            limit = 10;
        }
        let str = tags.join(";\n");
        const queryEmbedded = await this.embeddingModel.embedQuery(str);
        let foundAlarms = await this.vectorDB.similaritySearch(queryEmbedded, limit, 1, type);
        let ids = [];
        for (let alarm of foundAlarms) {
            // if (alarm.score < 0.5 && ids.length > tags.length) {
            //   break;
            // }
            if (limit <= ids.length) {
                break;
            }
            ids.push(alarm.metadata.source);
        }
        return ids;
    }
    /**
     * Get historical alarms
     */
    async getHistoricalAlarms(input) {
        let ids = [];
        if (input.alarms && input.alarms.length > 0) {
            ids = await this.getIds(input.alarms, "alarm");
        }
        let halFcn = commfunctions.getHistoAlarms.bind({ tenantID: this.tenantId });
        let to = new Date();
        let from = new Date(to.getTime() - 7 * 1000 * 60 * 60 * 24);
        if (input.from) {
            try {
                from = new Date(input.from);
            }
            catch (e) { }
        }
        if (input.to) {
            try {
                to = new Date(input.to);
            }
            catch (e) { }
        }
        let historyAlarms;
        if (ids.length > 0) {
            historyAlarms = await halFcn(this.lang, from, to, input.limit ? input.limit : 1000, undefined, undefined, undefined, 10, ids);
        }
        else {
            historyAlarms = await halFcn(this.lang, from, to, input.limit ? input.limit : 1000, undefined, undefined, undefined, 10);
        }
        let textHistory = "### " + (0, tools_1.getKey)(this.lang, "alarmHistory") + " ###\n" + (0, tools_1.formatAlarmHistory)(this.configObj, this.tenantId, this.lang, historyAlarms);
        return [textHistory, { alarmIDs: ids }];
    }
    /**
     * LLM resolver for relative time
     */
    async resolveRelativeRangeWithLLM(query) {
        const prompt = [
            {
                role: "system",
                content: `You convert vague time expressions into normalized calendar ranges.
Return JSON { "kind": "last" | "this" | "next", "unit": "day" | "week" | "month" | "year" | "hour" | "minute" | "second", "value"?: number }.
- "last week" → { "kind": "last", "unit": "week", "value": 1 }
- "this week" → { "kind": "this", "unit": "week" }
- "last 2 hours" → { "kind": "last", "unit": "hour", "value": 2 }
- "yesterday" → { "kind": "last", "unit": "day", "value": 1 }
- "today" → { "kind": "this", "unit": "day" }
- If no time reference, return {}.
`,
            },
            { role: "user", content: query },
        ];
        const res = await this.llm.invoke(prompt);
        try {
            let range = (0, tools_1.resolveRange)(JSON.parse(res.content));
            return range;
        }
        catch (e) {
            return {};
        }
    }
}
exports.default = ScadaHelpers;
